% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array.R
\name{as_nanoarrow_array}
\alias{as_nanoarrow_array}
\title{Convert an object to a nanoarrow array}
\usage{
as_nanoarrow_array(x, ..., schema = NULL)
}
\arguments{
\item{x}{An object to convert to a array}

\item{...}{Passed to S3 methods}

\item{schema}{An optional schema used to enforce conversion to a particular
type. Defaults to \code{\link[=infer_nanoarrow_schema]{infer_nanoarrow_schema()}}.}
}
\value{
An object of class 'nanoarrow_array'
}
\description{
In nanoarrow an 'array' refers to the \verb{struct ArrowArray} definition
in the Arrow C data interface. At the R level, we attach a
\link[=as_nanoarrow_schema]{schema} such that functionally the nanoarrow_array
class can be used in a similar way as an \link[arrow:array]{arrow::Array}. Note that in
nanoarrow an \link[arrow:RecordBatch]{arrow::RecordBatch} and a non-nullable \link[arrow:array]{arrow::StructArray}
are represented identically.
}
\examples{
(array <- as_nanoarrow_array(1:5))
as.vector(array)

(array <- as_nanoarrow_array(data.frame(x = 1:5)))
as.data.frame(array)

}
