% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_name.R
\name{drop_name}
\alias{drop_name}
\title{drop_name}
\usage{
drop_name(
  bib,
  cite_key,
  output_dir = "visual_citations",
  export_as = "html",
  max_authors = 3,
  include_qr = "link",
  qr_size = 250,
  qr_color = "#000000",
  vc_width = 600,
  style = "modern",
  path_absolute = FALSE,
  use_xaringan = FALSE,
  clean_strings = TRUE,
  ...
)
}
\arguments{
\item{bib}{Accepts one of the following:
1) A data.frame or tibble containing the columns YEAR, JOURNAL, AUTHOR, TITLE, BIBTEXKEY (all mandatory) and DOI, URL (optional).
2) A file path to a bibliography file in BibTeX/BibLaTeX format (usually *.bib file).}

\item{cite_key}{If given, either a character string or a vector of strings are accepted.
Specifies the reference items within the bibliography for which visual citations should be created.
If no key is specified, a visual citation is created for ALL reference items within the bibliography.
In other words, either one, many or no BibTeX citation keys can be specified.}

\item{output_dir}{A string specifying the relative path, where the rendered output files should be stored.}

\item{export_as}{A string specifying the desired output format. For now supports PNG and HTML.
Use "html" to include the 'bare' taglist (recommended for inclusion in Rmarkdown documents) or "html_full" to write a standalone .html file including <head> etc.
The PNG is a screenshot of the rendered HTML via the 'webshot' package. The filename represents this two step approach on purpose.
For webshot you need to install phantomJS once (see 'webshot' documentation).}

\item{max_authors}{Integer number of maximum authors to print. If the number of authors exceeds this, the list is cropped accordingly.}

\item{include_qr}{Character string specifying the way the QR code should be included or if no QR code should be included.
'embed' results in a stand alone <img> tag within the HTML object, other options are ignored for the time being.
'link' (default) creates a PNG of the QR code and stores it in a subfolder of the HTML file's location. The HTML <img> tag links to this file then.
'link_svg' creates a SVG of the QR code and stores it in a subfolder of the HTML file's location. The HTML <img> tag links to this file then.
'none' creates no QR code.}

\item{qr_size}{Specifies the height/width of the rendered QR code in px. Default: 250px, minimum: 150px. Ignored for SVG output.}

\item{qr_color}{Specifies the foreground color of the QR code as hex-string, e.g. "#00FF00"; default is black: "#000000".}

\item{vc_width}{Specifies the width of the text part of the visual citation in px.
This can be adjusted to accommodate e.g. untypically long or short titles. Default: 600px}

\item{style}{A string specifying the desired style for the visual citation. Possible values are:
"modern", "classic", "clean", "fancy", "newspaper", "compact" and "none".
If "compact" is given, the rendered VC contains
only the last name of the first author and the publication year, next to the QR code.
If "none" is given, the returned html can use a custom css file provided by the user.
This custom CSS file must specify styles for <div> classes "top-row", "title-row" and "author-row". (see vignette)}

\item{path_absolute}{Boolean to specify, whether the returned output path is a relative path or an absolute path.}

\item{use_xaringan}{Boolean to specify if an HTML output is intended to be included in an HTML presentation (like e.g. xaringan) or not.
When including the visual citation via htmltools::includeHTML(), the QR code needs to be in a subfolder
relative to the rendered presentation, not relative to the visual citation.}

\item{clean_strings}{Removes curly braces {} from titles and journal names, as they are often present in
BibTeX strings, but not needed for the rendering. TRUE by default, but can be set to FALSE, if the {} are needed.}

\item{...}{Allows for custom style arguments to override predefined styles. Supported are: author_size, author_font,
author_weight, author_color, title_size, title_font, title_weight, title_color,
journal_size, journal_font, journal_weight, journal_color. Fonts need to be installed on the system.}
}
\value{
A character string with the file path to the created visual citation in the specified output format.
}
\description{
Extracts metadata from a .bib file and exports the visual citation in the specified format.
}
\examples{

# create sample data
\dontrun{
bib_tbl <- dplyr::tribble(
  ~TITLE, ~AUTHOR, ~JOURNAL, ~BIBTEXKEY, ~YEAR,
  "Some title", c("Alice", "Bob", "Charlie"),
  "Journal of Unnecessary R Packages",
  "Alice2022", "2022"
)

# create visual citation
drop_name(
  bib = bib_tbl,
  cite_key = "Alice2022",
  export_as = "png",
  max_authors = 2,
  style = "clean",
  output_dir = "visual_citations",
  author_color = "#FF0000",
  author_weight = "normal",
  author_size = "12pt",
  author_font = "Roboto",
  title_color = "#00FF00",
  title_weight = "bold",
  title_size = "2.5rem",
  title_font = "Playfair Display",
  journal_color = "#0000FF",
  journal_weight = "bold",
  journal_size = "8pt",
  journal_font = "Fira Sans",
  qr_size = 150,
  qr_color = "#AAAAAA"
)
}

}
