% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generating_vector.R
\name{genVecQMC}
\alias{genVecQMC}
\title{Generating vectors for lattice rules}
\usage{
genVecQMC(p, d, bt = rep(1, d), gm = c(1, (4/5)^(0:(d - 2))))
}
\arguments{
\item{p}{A prime number corresponding to the number of samples to use.}

\item{d}{Dimension of the multivariate integral to estiamte.}

\item{bt}{Tuning parameter for finding the vector. See D. Nuyens and R. Cools (2004) for more details.}

\item{gm}{Tuning parameter for finding the vector. See D. Nuyens and R. Cools (2004) for more details.}
}
\value{
A \code{d}-dimensional generating vector for lattice rules with \code{p} samples.
}
\description{
Compute a generating vector for quasi-Monte Carlo estimation
}
\details{
The function computes a generating vector for efficient multivariate integral estimation
based on D. Nuyens and R. Cools (2004).
}
\examples{
#Define the number of sample. Muste be a prime number.
p <- 499

#Choose a dimension
d <- 300

#Compute the generating vector
genVecQMC(p,d)

}

