% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{modelPerformance.merMod}
\alias{modelPerformance.merMod}
\title{modelPerformance method for merMod objects}
\usage{
\method{modelPerformance}{merMod}(object, ...)
}
\arguments{
\item{object}{A model from \code{lmer}.}

\item{...}{Additional arguments, not currently used.}
}
\value{
a named vector with the marginal and conditional R2 values,
  if \code{CLUSTER = FALSE}, otherwise, a data table with the pseudo R2
  for each cluster unit.
 A list with a \code{data.table} with the following elements:
  \describe{
  \item{Model}{A character string indicating the model type, here merMod}
  \item{Estimator}{A character string indicating whether the model was estimated with REML or ML}
  \item{N_Obs}{The number of observations}
  \item{N_Groups}{A character string indicating the number of unique units in each grouping/clustering variable.}
  \item{AIC}{Akaike Information Criterion}
  \item{BIC}{Bayesian Information Criterion}
  \item{LL}{log likelihood}
  \item{LLDF}{log likelihood degrees of freedom}
  \item{Sigma}{Residual standard deviation}
  \item{MarginalR2}{in sample variance explained by the fixed effects}
  \item{ConditionalR2}{in sample variance explained by the fixed and random effects}
  \item{MarginalF2}{Cohen's F2 effect size R2 / (1 - R2) based off the Marginal R2}
  \item{ConditionalF2}{Cohen's F2 effect size R2 / (1 - R2) based off the Conditional R2}
  }
}
\description{
For pseudo R2 by cluster, the squared correlation between observed
and predicted values for each cluster unit is returned.  For the overall model,
the marginal and conditional R2 are calculated as described in the references.
}
\examples{

library(JWileymisc)
data(aces_daily, package = "JWileymisc")
m1 <- lme4::lmer(PosAff ~ 1 + (1 | UserID),
  data = aces_daily)
modelPerformance(m1)

m1 <- lme4::lmer(PosAff ~ STRESS + (1 + STRESS | UserID),
  data = aces_daily)
modelPerformance(m1)

rm(m1)
}
\references{
For estimating the marginal and conditional R-squared values,
  see:
  Nakagawa, S. and Schielzeth, H. (2013) <doi:10.1111/j.2041-210x.2012.00261.x>
  "A general and simple method for obtaining R2 from generalized linear mixed-effects models"
  and also:
  Johnson, P. C. (2014) <doi:10.1111/2041-210X.12225>
  "Extension of Nakagawa & Schielzeth's R2GLMM to random slopes models"
}
