% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_tgrid.R, R/class_mrgmod.R
\docType{methods}
\name{tgrid}
\alias{tgrid}
\alias{stime,tgrid-method}
\alias{stime,tgrids-method}
\alias{stime,numeric-method}
\alias{show,tgrid-method}
\alias{show,tgrids-method}
\alias{stime,mrgmod-method}
\title{Create a simtime object}
\usage{
tgrid(start = 0, end = 24, delta = 1, add = numeric(0), .offset = 0,
  .scale = 1, ...)

\S4method{stime}{tgrid}(x, ...)

\S4method{stime}{tgrids}(x, ...)

\S4method{stime}{numeric}(x, ...)

\S4method{show}{tgrid}(object)

\S4method{show}{tgrids}(object)

\S4method{stime}{mrgmod}(x, ...)
}
\arguments{
\item{start}{simulation start time}

\item{end}{simulation end time}

\item{delta}{simulation time step}

\item{add}{addition simulation times}

\item{.offset}{the resulting set of times will be adjusted by this amount}

\item{.scale}{the resulting set of times will be scaled by this factor}

\item{...}{passed on to other methods}

\item{x}{tgrid object}

\item{object}{passed to show}
}
\description{
simtime objects allow the user to specify simulation start and end times, 
along with the simulation time step.
}
\examples{

peak <- tgrid(0,6,0.2)
sparse <- tgrid(0,24,4)

day1 <- c(peak,sparse)

design <- c(day1, day1+72, day1+240)

\dontrun{
mod <- mrgsolve:::house()

out <- mod \%>\% ev(amt=1000, ii=24, addl=10) \%>\% mrgsim(tgrid=design)

plot(out,CP~., type='b')
}
}
