% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{ev_seq}
\alias{ev_seq}
\alias{seq.ev}
\title{Schedule a series of event objects}
\usage{
ev_seq(..., ID = NULL, .dots = NULL, id = NULL)

\method{seq}{ev}(...)
}
\arguments{
\item{...}{event objects or numeric arguments named \code{wait}}

\item{ID}{numeric vector of subject IDs}

\item{.dots}{a list of event objects that replaces \code{...}}

\item{id}{deprecated; use \code{ID}}
}
\value{
A single event object.
}
\description{
Schedule a series of event objects
}
\details{
The doses for the next event line start after 
all of the doses from the previous event line plus 
one dosing interval from the previous event line (see
examples).  

When numerics named \code{wait} are mixed in with the 
event objects, a period with no dosing activity is 
incorporated into the sequence, between the adjacent 
dosing event objects.  Values for \code{wait} can
be negative.

Values for \code{time} in any event object act like
a prefix time spacer wherever that event 
occurs in the event sequence (see examples).

Use the generic \code{\link{seq}} when the first argument 
is an event object.  If a waiting period is the 
first event, you will need to use \code{ev_seq}.  When 
an event object has multiple rows, the end time for 
that sequence is taken to be one dosing interval 
after the event that takes place on the last 
row of the event object.
}
\examples{

e1 <- ev(amt=100, ii=12, addl=1)

e2 <- ev(amt=200)

seq(e1, e2)

seq(e1, .ii = 8, e2)

seq(e1, wait = 8, e2)

seq(e1, .ii = 8, e2, ID = 1:10)

ev_seq(.ii = 12, e1, .ii = 120, e2, .ii = 120, e1)

seq(ev(amt=100, ii=12), ev(time=8, amt=200))

}
