% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moverank.R
\name{moverank}
\alias{moverank}
\title{R function for calculating sub-optimal least-cost paths bewteen an origin and a destination location}
\usage{
moverank(
  dtm = NULL,
  origin,
  destin,
  studyplot = NULL,
  barrier = NULL,
  plot.barrier = FALSE,
  irregular.dtm = FALSE,
  funct = "t",
  time = "h",
  lcp.n = 3,
  move = 16,
  cogn.slp = FALSE,
  sl.crit = 10,
  W = 70,
  L = 0,
  N = 1,
  V = 1.2,
  z = 9,
  use.corr = FALSE,
  leg.pos = "topright",
  leg.cex = 0.55,
  add.chart = FALSE,
  bubble.cex = 0.5,
  transp = 0.5,
  export = FALSE
)
}
\arguments{
\item{dtm}{Digital Terrain Model (RasterLayer class); if not provided, elevation data will be acquired online for the area enclosed by the 'studyplot' parameter (see \code{\link{movecost}}).}

\item{origin}{first location from which the least-cost corridor is calculated (SpatialPointsDataFrame class); if it contains more than two locations, see the 'Description' section above.}

\item{destin}{second location from which the least-cost corridor is calculated (SpatialPointsDataFrame class); if parameter 'a' stores more than two locations, this parameter is disregarded; see the 'Description' section above.}

\item{studyplot}{polygon (SpatialPolygonDataFrame class) representing the study area for which online elevation data are acquired (see \code{\link{movecost}}); NULL is default.}

\item{barrier}{area where the movement is inhibited (SpatialLineDataFrame or SpatialPolygonDataFrame class) (see \code{\link{movecost}}).}

\item{plot.barrier}{TRUE or FALSE (default) if the user wants or does not want the barrier to be plotted (see \code{\link{movecost}}).}

\item{irregular.dtm}{TRUE or FALSE (default) if the input DTM features irregular margins (see \code{\link{movecost}}).}

\item{funct}{cost function to be used (for details on each of the following, see \code{\link{movecost}}):\cr

\strong{-functions expressing cost as walking time-}\cr
\strong{t} (default) uses the on-path Tobler's hiking function;\cr
\strong{tofp} uses the off-path Tobler's hiking function;\cr
\strong{mp} uses the Marquez-Perez et al.'s modified Tobler's function;\cr
\strong{icmonp} uses the Irmischer-Clarke's hiking function (male, on-path);\cr
\strong{icmoffp} uses the Irmischer-Clarke's hiking function (male, off-path);\cr
\strong{icfonp} uses the Irmischer-Clarke's hiking function (female, on-path);\cr
\strong{icfoffp} uses the Irmischer-Clarke's hiking function (female, off-path);\cr
\strong{ug} uses the Uriarte Gonzalez's walking-time cost function;\cr
\strong{ma} uses the Marin Arroyo's walking-time cost function;\cr
\strong{alb} uses the Alberti's Tobler hiking function modified for pastoral foraging excursions;\cr
\strong{gkrs} uses the Garmy, Kaddouri, Rozenblat, and Schneider's hiking function;\cr
\strong{r} uses the Rees' hiking function;\cr
\strong{ks} uses the Kondo-Seino's hiking function;\cr
\strong{trp} uses the Tripcevich's hiking function;\cr

\strong{-functions for wheeled-vehicles-}\cr
\strong{wcs} uses the wheeled-vehicle critical slope cost function;\cr

\strong{-functions expressing abstract cost-}\cr
\strong{ree} uses the relative energetic expenditure cost function;\cr
\strong{b} uses the Bellavia's cost function;\cr
\strong{e} uses the Eastman's cost function;\cr

\strong{-functions expressing cost as metabolic energy expenditure-}\cr
\strong{p} uses the Pandolf et al.'s metabolic energy expenditure cost function;\cr
\strong{pcf} uses the Pandolf et al.'s cost function with correction factor for downhill movements;\cr
\strong{m} uses the Minetti et al.'s metabolic energy expenditure cost function;\cr
\strong{hrz} uses the Herzog's metabolic energy expenditure cost function;\cr
\strong{vl} uses the Van Leusen's metabolic energy expenditure cost function;\cr
\strong{ls} uses the Llobera-Sluckin's metabolic energy expenditure cost function;\cr
\strong{a} uses the Ardigo et al.'s metabolic energy expenditure cost function;\cr
\strong{h} uses the Hare's metabolic energy expenditure cost function (for all the mentioned cost functions, see \code{\link{movecost}}).\cr}

\item{time}{time-unit expressed by the accumulated raster if Tobler's and other time-related cost functions are used; h' for hour, 'm' for minutes.}

\item{lcp.n}{number of LCPs rendered in the output plot (min=1, max=6; 3 by default; the 1st LCP is the optimal one, while the LCPs from the 2nd to the 6th are the sub-optimal ones).}

\item{move}{number of directions in which cells are connected: 4 (rook's case), 8 (queen's case), 16 (knight and one-cell queen moves; default).}

\item{cogn.slp}{TRUE or FALSE (default) if the user wants or does not want the 'cognitive slope' to be used in place of the real slope (see \code{\link{movecost}}).}

\item{sl.crit}{critical slope (in percent), typically in the range 8-16 (10 by default) (used by the wheeled-vehicle cost function; see \code{\link{movecost}}).}

\item{W}{walker's body weight (in Kg; 70 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{L}{carried load weight (in Kg; 0 by default; used by the Pandolf's and Van Leusen's cost function; see \code{\link{movecost}}).}

\item{N}{coefficient representing ease of movement (1 by default) (see \code{\link{movecost}}).}

\item{V}{speed in m/s (1.2 by default) (used by the Pandolf et al.'s, Pandolf et al.s with correction factor, Van Leusen's, and Ardigo et al.'s cost function; if set to 0, it is internally worked out on the basis of Tobler on-path hiking function (see \code{\link{movecost}}).}

\item{z}{zoom level for the elevation data downloaded from online sources (from 0 to 15; 9 by default) (see \code{\link{movecost}} and \code{\link[elevatr]{get_elev_raster}}).}

\item{use.corr}{TRUE or FALSE (default) is the user wants or does not want the least-cost corridor raster to be rendered in place of the input DTM.}

\item{leg.pos}{set the position of the legend in rendered plot; 'topright' by default (other options: "bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", "right", "center").}

\item{leg.cex}{set the size of the labels used in the legend displayed in the rendered plot (0.55 by default).}

\item{add.chart}{TRUE or FALSE (default) is the user wants or does not want a bubble chart visualising LCPs length vs rank vs cost to be rendered.}

\item{bubble.cex}{set the size of the labels reporting the LCPs cost in the bubble chart (0.5 by default).}

\item{transp}{set the transparency of the slopeshade raster that is plotted over the least-cost corridor raster (0.5 by default).}

\item{export}{TRUE or FALSE (default) if the user wants or does not want the output to be exported; if TRUE, the least-cost corridor and the DTM (if not provided by the user but acquired online)
are expoerted as a GeoTiff file, while the LCPs as a shapefile layer. All the exported files (excluding the DTM) will bear a suffix corresponding to the cost function selected by the user.}
}
\value{
The function returns a list storing the following components \itemize{
 \item{dtm: }{Digital Terrain Model ('RasterLayer' class); returned only if not provided by the user and acquired online instead}
 \item{LCPs: }{least-cost paths ('SpatialLinesDataFrame' class) ranked from 1 (optimal) to 6 (sub-optimal LCPs)}
 \item{lc.corr: }{least-cost corridor between the origin and destination location ('RasterLayer' class); returned if the \code{use.corr} parameter is set to \code{TRUE}}
}
}
\description{
The function provides the facility to calculate the LCP between an origin and a destination location and (more importantly) to
work out the first six sub-optimal LCPs between those locations. The underlying idea is the following: given two locations, we can
calculate the least-costly path between them; but, if we disregard that LCP, what path would be the second least costly?
And if we in turn disregard those first two, what the third least costly path would be? The same reasoning holds for all the subsequent n-th LCPs. Under the hood,
\code{moverank()} rests on \code{\link{movecost}} and implements the same cost functions. See the help documentation of \code{movecost()} for further details.\cr
Visit this \href{https://drive.google.com/file/d/1gLDrkZFh1b_glzCEqKdkPrer72JJ9Ffa/view?usp=sharing}{LINK} to access the package's vignette.\cr
}
\details{
Internally, \code{moverank()} uses \code{movecost()} to generate the first (optimal) LCP. In a second iteration,
the optimal LCP is internally used as barrier (see \code{\link{movecost}}) when calculating the 2nd LCPs. Then, in a third iteration,
the two previously generated LCPs are used as barriers when working out the 3rd LCPs. The process repeats along the same lines until the
6th LCP is calculated. The 1st LCP is deemed to represent the optimal path (cost-wise) between the two locations, while the
2nd-to-5th LCPs are deemed to represent progressively sub-optimal paths.\cr

It is worth noting that it may happen that some LCP will cross another one; this cannot be anticipated and is context dependent.
In those cases, the user may want to set the \code{move} parameter to 8 (see the section about
inhibition of movement in the help documentation of \code{\link{movecost}}). \cr

The function provides the facility to render the LCPs either on the input DTM or on the least-cost corridor
between the two locations. The second option can be obtained by setting the \code{use.corr} parameter to \code{TRUE}.
Also, by setting the \code{add.chart} parameter to \code{TRUE}, the function renders a bubble chart that plots the LCPs length
against their rank, while the size of the bubbles is proportional to the cost. All the LCPs will be plotted.\cr

By setting the \code{export} parameter to \code{TRUE}, the LCPs, the DTM (if acquired online), and the least-cost corridor
(if obtained by setting the \code{use.corr} parameter to \code{TRUE}), will be exported: the DTM and least-cost corridor as a raster layer,
the LCPs as shapefile layer. The LCPs and the least-cost corridor files will be given a suffix indicating which cost function has been used.\cr
}
\examples{
# load a sample Digital Terrain Model
data(volc)


# load the sample destination locations on the above DTM
data(destin.loc)

# calculate the optimal and sub-optimals LCPs between two locations
#result <- moverank(volc, destin.loc[1,], destin.loc[4,], move=8, funct="t")

}
\seealso{
\code{\link{movecost}}
}
\keyword{moverank}
