% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{KH2017}
\alias{KH2017}
\title{Mouse-tracking dataset from Kieslich & Henninger (2017)}
\format{A mousetrap data object is a \link{list} containing  at least the
  following objects:
  \itemize{
    \item{\code{data}: a \link{data.frame} containing the trial data (from 
    which the mouse-tracking data columns have been removed). More 
    information about the content of the trial data in \code{KH2017} can 
    be found in \link{KH2017_raw}. The \link{rownames} of \code{data} 
    correspond to the trial identifier. For convenience, the trial identifier
    is also stored in an additional column called "mt_id".} 
    \item{\code{trajectories}: an \link{array} containing the raw 
    mouse-tracking trajectories. The first dimension represents the different
    trials and the dimension names (which can be accessed using 
    \link{rownames}) correspond to the trial identifier (the same identifier 
    that is used as the \code{rownames} in \code{data}). The second dimension
    corresponds to the samples taken over time which are included in
    chronological order. The third dimension corresponds to the different
    mouse-tracking variables (timestamps, x-positions, y-positions) which are
    usually called \code{timestamps}, \code{xpos}, and \code{ypos}. }
  }

  Some functions in this package (e.g., \link{mt_time_normalize} and
  \link{mt_average}) add additional trajectory arrays (e.g.,
  \code{tn_trajectories} and \code{av_trajectories}) to the mousetrap data
  object. Other functions modify the existing arrays (e.g.,
  \link{mt_derivatives} adds distance, velocity, and acceleration
  to an existing dataset). Finally \link{mt_measures} adds an
  additional data.frame with mouse-tracking measures to it.}
\usage{
KH2017
}
\description{
A data object of class "mousetrap" with the imported and preprocessed
mouse-tracking data from Kieslich & Henninger (2017). More information about
the study and raw data can be found in \link{KH2017_raw}.
}
\details{
The raw dataset (\link{KH2017_raw}) was filtered keeping only correctly 
answered trials. The filtered dataset was imported using 
\link{mt_import_mousetrap}. Trajectories were then remapped using 
\link{mt_remap_symmetric} so that all trajectories end in the top-left corner
and their starting point was aligned to a common value (0,0) using
\link{mt_align_start}.
}
\references{
Kieslich, P. J., & Henninger, F. (2017). Mousetrap: An 
  integrated, open-source mouse-tracking package. \emph{Behavior Research 
  Methods, 49}(5), 1652-1667. \url{https://doi.org/10.3758/s13428-017-0900-z}
  
  Dale, R., Kehoe, C., & Spivey, M. J. (2007). Graded motor responses in the 
  time course of categorizing atypical exemplars. \emph{Memory & Cognition, 
  35}(1), 15-28. \url{https://doi.org/10.3758/BF03195938}
}
\keyword{datasets}
