% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{mt_cluster}
\alias{mt_cluster}
\title{Cluster trajectories.}
\usage{
mt_cluster(data, use = "sp_trajectories", save_as = "clustering",
  dimensions = c("xpos", "ypos"), n_cluster = 5, method = "hclust",
  pointwise = TRUE, minkowski_p = 2, hclust_method = "ward.D",
  kmeans_nstart = 10, cluster_output = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the resulting data should
be stored.}

\item{dimensions}{a character vector specifying which trajectory variables 
should be used. Can be of length 2 or 3, for two-dimensional or 
three-dimensional trajectories respectively.}

\item{n_cluster}{an integer specifying the number of clusters to estimate.}

\item{method}{character string specifiying the clustering procedure. Either
\link[fastcluster]{hclust} (the default) or \link[stats]{kmeans}.}

\item{pointwise}{boolean specifying the way in which dissimilarity between
the trajectories is measured. If \code{TRUE} (the default),
\code{mt_distmat} measures the average dissimilarity and then sums the
results. If \code{FALSE}, \code{mt_distmat}  measures dissimilarity once
(by treating the various points as independent dimensions). This is only
relevant if \code{method} is "hclust". See \link{mt_distmat} for further
details.}

\item{minkowski_p}{an integer specifying the distance metric for the cluster
solution. \code{minkowski_p = 1} computes the city-block distance,
\code{minkowski_p = 2} (the default) computes the Euclidian distance,
\code{minkowski_p = 3} the cubic distance, etc. Only relevant if
\code{method} is "hclust". See \link{mt_distmat} for further details.}

\item{hclust_method}{character string specifying the linkage criterion used. 
Passed on to the \code{method} argument of \link[stats]{hclust}. Default is
set to \code{ward.D}. Only relevant if \code{method} is "hclust".}

\item{kmeans_nstart}{integer specifying the number of reruns of the kmeans 
procedure. Larger numbers minimize the risk of finding local minima. Passed
on to the \code{nstart} argument of \link[stats]{kmeans}. Only relevant if 
\code{method} is "kmeans".}

\item{cluster_output}{logical. If \code{FALSE} (the default), the mousetrap 
data object with the cluster assignments is returned (see Value). If 
\code{TRUE}, the output of the cluster method (\code{kmeans} or 
\code{hclust}) is returned directly.}

\item{verbose}{logical indicating whether function should report its
progress.}
}
\value{
A mousetrap data object (see \link{mt_example}) with an additional
  \link{data.frame} added to it (by default called \code{clustering}) that
  contains the cluster assignments. If a trajectory array was provided
  directly as \code{data}, only the clustering \code{data.frame} will be
  returned.
}
\description{
Performs trajectory clustering. It first computes distances between each pair
of trajectories and then applies off-the-shelf clustering tools to explain 
the resulting dissimiliarity matrix using a predefined number of clusters.
}
\details{
\code{mt_cluster} uses off-the-shelf clustering tools, i.e., 
\link[fastcluster]{hclust} and \link[stats]{kmeans}, for cluster estimation. 
Cluster estimation using \link[fastcluster]{hclust} relies on distances 
computed by \link{mt_distmat}.

Mouse trajectories often occur in distinct, qualitative types (see Wulff, 
Haslbeck, Schulte-Mecklenbeck, 2017; Haslbeck, Wulff, Kieslich, Henninger, & 
Schulte-Mecklenbeck, 2017). Common trajectory types are linear trajectories, 
mildly and strongly curved trajctories, and single and multiple 
change-of-mind trials (see also \link{mt_map}). \code{mt_cluster} can tease
these types apart.

\code{mt_cluster} uses \link[fastcluster]{hclust} or \link[stats]{kmeans} to 
explain the distances between every pair of trajectories using a predefined 
number of clusters. If method is "hclust", \code{mt_cluster} computes the 
dissimiliarity matrix for all trajectory pairs using \link{mt_distmat}. If
method is "kmeans", this is done internally by \link[stats]{kmeans}.

We recommend setting \code{method} to \link[fastcluster]{hclust} using 
\code{ward.D} as the linkage criterion (via \code{hclust_method}). Relative 
to \link[stats]{kmeans}, the other implemented clustering method, and other 
linkage criteria, this setup handles the skewed distribution cluster sizes 
and trajectory outliers found in the majority of datasets best.

For clustering trajectories, it is often useful that the endpoints of all
trajectories share the same direction, e.g., that all trajectories end in the
top-left corner of the coordinate system (\link{mt_remap_symmetric} or
\link{mt_align} can be used to achieve this). Furthermore, it is recommended
to use spatialized trajectories (see \link{mt_spatialize}; Haslbeck, Wulff,
Kieslich, Henninger, & Schulte-Mecklenbeck, 2017).
}
\examples{
# Spatialize trajectories
mt_example <- mt_spatialize(mt_example)

# Cluster trajectories
mt_example <- mt_cluster(mt_example, use="sp_trajectories")

}
\references{
Wulff, D. U., Haslbeck, J. M. B., & Schulte-Mecklenbeck, M. 
  (2017). Measuring the (dis-)continuous mind. Manuscript in preparation.
  
  Haslbeck, J. M. B., Wulff, D. U., Kieslich, P. J., Henninger, F., & 
  Schulte-Mecklenbeck, M. (2017). Advanced mouse- and hand-tracking analysis:
  Detecting and visualizing clusters in movement trajectories. Manuscript in 
  preparation.
}
\seealso{
\link{mt_distmat} for more information about how the distance matrix is 
computed when the hclust method is used.

\link{mt_cluster_k} for estimating the optimal number of clusters.
}
\author{
Dirk U. Wulff (\email{dirk.wulff@gmail.com})

Jonas M. B. Haslbeck (\email{jonas.haslbeck@gmail.com})
}
