% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{mt_align_start}
\alias{mt_align_start}
\title{Align start position of trajectories.}
\usage{
mt_align_start(data, use = "trajectories", save_as = "trajectories",
  dimensions = c("xpos", "ypos"), start = c(0, 0), verbose = FALSE,
  xpos_start = NULL, ypos_start = NULL, show_progress = NULL)
}
\arguments{
\item{data}{a mousetrap data object created using one of the mt_import
functions (see \link{mt_example} for details). Alternatively, a trajectory
array can be provided directly (in this case \code{use} will be ignored).}

\item{use}{a character string specifying which trajectory data should be
used.}

\item{save_as}{a character string specifying where the resulting trajectory
data should be stored.}

\item{dimensions}{a character vector specifying the dimensions in the
trajectory array that should be space-normalized.}

\item{start}{a numeric vector specifying the start values for each dimension,
i.e., the values the first recorded position should have in every trial.}

\item{verbose}{logical indicating whether function should report its
progress.}

\item{xpos_start}{Deprecated. Please use \code{start} instead.}

\item{ypos_start}{Deprecated. Please use \code{start} instead.}

\item{show_progress}{Deprecated. Please use \code{verbose} instead.}
}
\value{
A mousetrap data object (see \link{mt_example}) with aligned
  trajectories. If the trajectory array was provided directly as \code{data},
  only the trajectory array will be returned.
}
\description{
Adjust trajectories so that all trajectories have the same start position.
}
\examples{
mt_example <- mt_align_start(mt_example,
  start=c(0,0))

}
\seealso{
\link{mt_space_normalize} for space normalizing trajectories.

\link{mt_remap_symmetric} for remapping trajectories.
}

