% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survData.R
\name{survData}
\alias{survData}
\title{Creates a dataset for survival analysis}
\usage{
survData(data)
}
\arguments{
\item{data}{a \code{data.frame} containing the following four columns:
\itemize{
\item \code{replicate}: a vector of class \code{integer} or factor for replicate
identification
\item \code{conc}: a vector of class \code{numeric} with tested concentrations
(positive values)
\item \code{time}: a vector of class \code{integer} with time points, min value must be 0
\item \code{Nsurv}: a vector of class \code{integer} providing the number of
alive individuals at each time point for each concentration and each replicate
}}
}
\value{
A dataframe of class \code{survData}.
}
\description{
This function creates a \code{survData} object from experimental data
provided as a \code{data.frame}. The resulting object
can then be used for plotting and model fitting. It can also be used
to generate \emph{individual-time} estimates.
}
\details{
The \code{data} argument describes experimental results from a survival
assay. Each line of the \code{data.frame}
corresponds to one experimental measurement, that is a number of alive
individuals for a given concentration of pollutant at a certain time
during the assay in a certain replicate. The function fails if
\code{data} does not meet the
expected requirements. Please run \code{\link{survDataCheck}} to ensure
\code{data} is well-formed.
}
\examples{

# (1) Load the survival dataset
data(zinc)

# (2) Create an objet of class 'survData'
dat <- survData(zinc)
class(dat)

}
\seealso{
\code{\link{survDataCheck}}
}
\keyword{transformation}

