\name{plo_part}
\alias{plo_part}

\title{
Plot of Main and Partial Effect
}

\description{
Plots the the main and partial effects of a supplementary variable for a PLS regression, with one or more supplementary partialled out.
}

\usage{
plo_part(object, var, controls, excl = NULL,
  comps = c(1,2), shapesize = 1.5, col = "black",
  textsize = 4, force = 1, max.overlaps = Inf,
  lines = TRUE, dashes = TRUE, alpha = 0.3, legend = "right")
}

\arguments{
  \item{object}{an object of class \code{mvr} from \code{pls} package}
  \item{var}{factor. The categorical supplementary variable.}
  \item{controls}{data frame of supplementary variables to be partialled out (i.e. control variables)}
  \item{excl}{character vector of categories from the var to exclude from the plot. If NULL (default), all the supplementary categories are plotted.}
  \item{comps}{the components to use. Default is \code{c(1,2)}.}
  \item{shapesize}{Size of the shapes. Default is 1.5.}
  \item{col}{the color for the labels and lines. Default is "black".}
  \item{textsize}{Size of the labels of categories. Default is 4.}
  \item{force}{Force of repulsion between overlapping text labels. Defaults to 1. If 0, labels are not repelled at all.}
  \item{max.overlaps}{Exclude text labels that overlap too many things. Defaults to Inf, which means no labels are excluded.}
  \item{lines}{logical. Whether to add colored lines between the points of the categories of v1. Default is TRUE.}
  \item{dashes}{logical. Whether to add gray dashed lines between the points of the categories of v2. Default is TRUE.}
  \item{alpha}{Numerical value. Transparency of the partial effects. Default is 0.3.}
  \item{legend}{the position of legends ("none", "left", "right", "bottom", "top", or two-element numeric vector). Default is right.}
}

\value{
a \code{ggplot2} object
}

\references{
Martens, H., Næs, T. (1989) Multivariate calibration. Chichester: Wiley.

Tenenhaus, M. (1998) La Regression PLS. Theorie et Pratique. Editions TECHNIP, Paris.
}

\author{
Nicolas Robette
}

\seealso{
\code{\link{plo_sup}}, \code{\link{plo_inter}}
}

\examples{
library(pls)
data(mpg, package = "ggplot2")
pls <- mvr(displ ~ cty + hwy + cyl,
           ncomp = 3,
           data = mpg,
           validation = "CV",
           method = "oscorespls")
supvars <- data.frame(class = factor(mpg$class), trans = factor(mpg$trans))
plo_inter(pls, factor(mpg$class), factor(mpg$trans), lines = FALSE, dashes = FALSE)
}

\keyword{ multivariate }
\keyword{ misc }
