% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_hego.R
\name{HEGO}
\alias{HEGO}
\title{HEGO: Efficient Global Optimization Algorithm based on the Hypervolume criteria}
\usage{
HEGO(
  model,
  fun,
  nsteps,
  lower = rep(0, model@d),
  upper = rep(1, model@d),
  quiet = TRUE,
  control = NULL,
  optimcontrol = NULL
)
}
\arguments{
\item{model}{An object of class \code{\link{mkm}}.}

\item{fun}{The multi-objective and constraint cost function to be optimized.
This function must return a vector with the size of \code{model@m + model@j}
where \code{model@m} are the number of objectives and
\code{model@j} the number of the constraints,}

\item{nsteps}{An integer representing the desired number of iterations,}

\item{lower}{Vector of lower bounds for the variables to be optimized over
(default: 0 with length \code{model@d}),}

\item{upper}{Vector of upper bounds for the variables to be optimized over
(default: 1 with length \code{model@d}),}

\item{quiet}{Logical indicating the verbosity of the routine,}

\item{control}{An optional list of control parameters, some of them passed to
the \code{\link[GPareto]{crit_EHI}} function. One can control:
\describe{
\item{\code{minimization}}{logical indicating if the EHVI is minimizing all
objectives (\code{TRUE}, by default) or maximizing all objectives
(\code{FALSE}). Mixed optimization is not currently accepted, if the user
needs it, the cost functions should be modified prior Kriging modeling
(i.e. inverting or multiplying the output by \code{-1}).}
\item{\code{paretoFront}}{object of class \code{\link{ps}} containing the
actual Pareto set. If not provided a Pareto set is built based on the
current feasible observations (\code{model@response[model@feasible,]}).}
\item{\code{nb.samp}}{number of random samples from the posterior distribution
 (with more than two objectives), default to 50, increasing gives more reliable
  results at the cost of longer computation time}
\item{\code{seed}}{seed used for the random samples (with more than two objectives);}
\item{\code{refPoint}}{reference point for Hypervolume Expected Improvement.
 If not provided, it is set to the maximum or minimum of each objective.}
 }}

\item{optimcontrol}{Optional list of control parameters passed to the
\code{\link[GenSA]{GenSA}} function. Please, note that the values are passed as
the \code{control} parameter inside the \code{GenSA} function (\code{genSA(control = optimcontrol)}).}
}
\value{
updated \code{\link{mkm}} model
}
\description{
Executes \code{nsteps} iterations of the HEGO method to an object of class
\code{\link{mkm}}. At each step, a kriging model is re-estimated (including
covariance parameters re-estimation) based on the initial design points plus
the points visited during all previous iterations; then a new point is
obtained by maximizing the Expected Hypervolume Improvement criterion (EHVI).
}
\examples{
# ----------------
# The Nowacki Beam
# ----------------
n <- 20
d <- 2
nsteps <- 1 # value has been set to 1 to save compliation time, change this value to 40.
fun <- nowacki_beam
doe <- replicate(d,sample(0:n,n))/n
res <- t(apply(doe, 1, fun))
model <- mkm(doe, res, modelcontrol = list(objective = 1:2, lower = rep(0.1,d)))
model <- HEGO(model, fun, nsteps, quiet = FALSE)
plot(nowacki_beam_tps$set)
points(ps(model@response[which(model@feasible),model@objective])$set, col = 'green', pch = 19)
}
