% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{makeDesign}
\alias{makeDesign}
\title{make a uniform, random, or user-specified  grid over some columns of a data.frame, and combine it with a grid of points to integrate over.}
\usage{
makeDesign(data, vars, n, uniform = TRUE, points, int.points)
}
\arguments{
\item{data}{a \code{data.frame} which must contain \code{vars} as well as at least one other column}

\item{vars}{character vector the columns in data to create the grid for}

\item{n}{two dimensional integer vector giving the resolution of the grid. the first element gives the grid on \code{vars} and the second on the other columns, which are sampled without replacement.}

\item{uniform}{logical, indicates whether a uniform grid is to be constructed.}

\item{points}{a named list which gives specific points for \code{vars}.}

\item{int.points}{a integer vector giving indices of the points in \code{data} to marginalize over.}
}
\value{
a \code{data.frame} with at most \code{n} dimensions.
}
\description{
makes a uniform, random, or user-specified grid over some columns of a data.frame and takes their Cartesian product with the other columns
}
\examples{
data = data.frame(w = seq(0, 1, length.out = 5),
  x = factor(letters[1:5]),
  y = ordered(1:5),
  z = 1:5,
  r = letters[1:5],
  stringsAsFactors = FALSE)
makeDesign(data, "z", c(10, 5), TRUE)

}
