% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NULLCPO.R
\docType{data}
\name{NULLCPO}
\alias{NULLCPO}
\title{CPO Composition Neutral Element}
\format{An object of class \code{NULLCPO} (inherits from \code{CPOPrimitive}, \code{CPORetrafo}, \code{CPOInverter}, \code{CPOTrained}, \code{CPO}) of length 0.}
\usage{
NULLCPO
}
\description{
\code{NULLCPO} is the neutral element of \code{\link{CPO}} and \code{\link{CPOTrained}} composition when using
\code{\link{\%>>\%}} or \code{\link{composeCPO}}. It is furthermore no effect when attached to a \code{\link[mlr:makeLearner]{Learner}}
using \code{\link{attachCPO}} (or \code{\link{\%>>\%}}), or when applied to data using \code{\link{applyCPO}}, \code{\link{invert}},
or \code{\link[stats]{predict}} (or, again, \code{\link{\%>>\%}}).

\code{NULLCPO} works as a stand-in for certain operations that have an "empty" return value:
It is returned when \code{\link{retrafo}} and \code{\link{inverter}} are applied to an object that has no retrafo or inverter
associated with it, and by \code{\link{pipeCPO}} when applied to an empty list.

\code{NULLCPO} can be checked using \code{\link{is.nullcpo}}, and converted from or to \code{NULL} using \code{\link{nullToNullcpo}} and
\code{\link{nullcpoToNull}}. Otherwise it behaves very similarly to other \code{\link{CPO}} or \code{\link{CPOTrained}} objects.
}
\seealso{
Other retrafo related: \code{\link{CPOTrained}},
  \code{\link{\%>>\%}}, \code{\link{applyCPO}},
  \code{\link{as.list.CPO}}, \code{\link{clearRI}},
  \code{\link{getCPOClass}}, \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.retrafo}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other inverter related: \code{\link{CPOTrained}},
  \code{\link{\%>>\%}}, \code{\link{applyCPO}},
  \code{\link{as.list.CPO}}, \code{\link{clearRI}},
  \code{\link{getCPOClass}}, \code{\link{getCPOName}},
  \code{\link{getCPOOperatingType}},
  \code{\link{getCPOPredictType}},
  \code{\link{getCPOProperties}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{getCPOTrainedCapability}},
  \code{\link{getCPOTrainedState}},
  \code{\link{is.inverter}},
  \code{\link{makeCPOTrainedFromState}},
  \code{\link{pipeCPO}}, \code{\link{print.CPOConstructor}}

Other CPO lifecycle related: \code{\link{CPOConstructor}},
  \code{\link{CPOLearner}}, \code{\link{CPOTrained}},
  \code{\link{CPO}}, \code{\link{\%>>\%}},
  \code{\link{attachCPO}}, \code{\link{composeCPO}},
  \code{\link{getCPOClass}},
  \code{\link{getCPOConstructor}},
  \code{\link{getCPOTrainedCPO}},
  \code{\link{identicalCPO}}, \code{\link{makeCPO}}

Other NULLCPO related: \code{\link{is.nullcpo}},
  \code{\link{nullToNullcpo}}, \code{\link{nullcpoToNull}}
}
\keyword{datasets}
