% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TaskSurv.R
\name{TaskSurv}
\alias{TaskSurv}
\title{Survival Task}
\description{
This task specializes \link[mlr3:Task]{mlr3::Task} and \link[mlr3:TaskSupervised]{mlr3::TaskSupervised} for possibly-censored survival
problems. The target is comprised of survival times and an event indicator.
Predefined tasks are stored in \link[mlr3:mlr_tasks]{mlr3::mlr_tasks}.

The \code{task_type} is set to \code{"surv"}.
}
\examples{
library(mlr3)
lung = mlr3misc::load_dataset("lung", package = "survival")
lung$status = (lung$status == 2L)
b = as_data_backend(lung)
task = TaskSurv$new("lung",
  backend = b, time = "time",
  event = "status")

task$target_names
task$feature_names
task$formula()
task$truth()
}
\seealso{
Other Task: 
\code{\link{TaskDens}}
}
\concept{Task}
\section{Super classes}{
\code{\link[mlr3:Task]{mlr3::Task}} -> \code{\link[mlr3:TaskSupervised]{mlr3::TaskSupervised}} -> \code{TaskSurv}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{censtype}}{\code{character(1)}\cr
Returns the type of censoring, one of "right", "left", "counting", "interval", "interval2"
or "mstate".}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{TaskSurv$new()}}
\item \href{#method-truth}{\code{TaskSurv$truth()}}
\item \href{#method-formula}{\code{TaskSurv$formula()}}
\item \href{#method-clone}{\code{TaskSurv$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="cbind">}\href{../../mlr3/html/Task.html#method-cbind}{\code{mlr3::Task$cbind()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="data">}\href{../../mlr3/html/Task.html#method-data}{\code{mlr3::Task$data()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="droplevels">}\href{../../mlr3/html/Task.html#method-droplevels}{\code{mlr3::Task$droplevels()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="filter">}\href{../../mlr3/html/Task.html#method-filter}{\code{mlr3::Task$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="format">}\href{../../mlr3/html/Task.html#method-format}{\code{mlr3::Task$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="head">}\href{../../mlr3/html/Task.html#method-head}{\code{mlr3::Task$head()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="help">}\href{../../mlr3/html/Task.html#method-help}{\code{mlr3::Task$help()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="levels">}\href{../../mlr3/html/Task.html#method-levels}{\code{mlr3::Task$levels()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="missings">}\href{../../mlr3/html/Task.html#method-missings}{\code{mlr3::Task$missings()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="print">}\href{../../mlr3/html/Task.html#method-print}{\code{mlr3::Task$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="rbind">}\href{../../mlr3/html/Task.html#method-rbind}{\code{mlr3::Task$rbind()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="rename">}\href{../../mlr3/html/Task.html#method-rename}{\code{mlr3::Task$rename()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="select">}\href{../../mlr3/html/Task.html#method-select}{\code{mlr3::Task$select()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_col_roles">}\href{../../mlr3/html/Task.html#method-set_col_roles}{\code{mlr3::Task$set_col_roles()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="mlr3" data-topic="Task" data-id="set_row_roles">}\href{../../mlr3/html/Task.html#method-set_row_roles}{\code{mlr3::Task$set_row_roles()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$new(
  id,
  backend,
  time,
  event,
  time2,
  type = c("right", "left", "counting", "interval", "interval2", "mstate")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{\code{backend}}{(\link{DataBackend})\cr
Either a \link{DataBackend}, or any object which is convertible to a \link{DataBackend} with \code{as_data_backend()}.
E.g., a \code{data.frame()} will be converted to a \link{DataBackendDataTable}.}

\item{\code{time}}{(\code{character(1)})\cr
Name of the column for event time if data is right censored, otherwise starting time if
interval censored.}

\item{\code{event}}{(\code{character(1)})\cr
Name of the column giving the event indicator.
If data is right censored then "0"/\code{FALSE} means alive (no event), "1"/\code{TRUE} means dead
(event). If \code{type} is \code{"interval"} then "0" means right censored, "1" means dead (event),
"2" means left censored, and "3" means interval censored. If \code{type} is \code{"interval2"} then
\code{event} is ignored.}

\item{\code{time2}}{(\code{character(1)})\cr
Name of the column for ending time for interval censored data, otherwise ignored.}

\item{\code{type}}{(\code{character(1)})\cr
Name of the column giving the type of censoring. Default is 'right' censoring.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-truth"></a>}}
\if{latex}{\out{\hypertarget{method-truth}{}}}
\subsection{Method \code{truth()}}{
True response for specified \code{row_ids}. Format depends on the task type.
Defaults to all rows with role "use".
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$truth(rows = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{\code{integer()}\cr
Row indices.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-formula"></a>}}
\if{latex}{\out{\hypertarget{method-formula}{}}}
\subsection{Method \code{formula()}}{
Creates a formula for survival models with \link[survival:Surv]{survival::Surv} on the LHS.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$formula(rhs = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rhs}}{If \code{NULL} RHS is \code{.}, otherwise gives RHS of formula.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{numeric()}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TaskSurv$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
