% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpDistrCompositor.R
\name{PipeOpDistrCompositor}
\alias{PipeOpDistrCompositor}
\alias{mlr_pipeops_distrcompositor}
\title{PipeOpDistrCompositor}
\format{\code{\link{R6Class}} inheriting from \code{\link{PipeOp}}.}
\description{
Estimates (or 'composes') a survival distribution from a predicted baseline \code{distr} and a
\code{crank} or \code{lp} from two \link{PredictionSurv}s.

Compositor Assumptions:
\itemize{
\item The baseline \code{distr} is a discrete estimator, i.e. \link{LearnerSurvKaplan} or \link{LearnerSurvNelson}
\item The composed \code{distr} is of a linear form
\item If \code{lp} is missing then \code{crank} is equivalent
}

These assumptions are strong and may not be reasonable. Future updates will upgrade this
compositor to be more flexible.
}
\section{Construction}{
\preformatted{PipeOpDistrCompositor$new(id = "distrcompose", param_vals = list())
}
\itemize{
\item \code{id} :: \code{character(1)} \cr
Identifier of the resulting  object, default \code{"distrcompose"}.
\item \code{param_vals} :: named \code{list} \cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\link{PipeOpDistrCompositor} has two input channels, "base" and "pred". Both input channels take
\code{NULL} during training and \link{PredictionSurv} during prediction.

\link{PipeOpDistrCompositor} has one output channel named "output", producing \code{NULL} during training
and a \link{PredictionSurv} during prediction.

The output during prediction is the \link{PredictionSurv} from the "pred" input but with an extra (or overwritten)
column for \code{distr} predict type; which is composed from the \code{distr} of "base" and \code{lp} or \code{crank}
of "pred".
}

\section{State}{

The \verb{$state} is left empty (\code{list()}).
}

\section{Parameters}{

The parameters are:
\itemize{
\item \code{form} :: \code{character(1)} \cr
Determines the form that the predicted linear survival model should take. This is either,
accelerated-failure time, \code{aft}, proportional hazards, \code{ph}, or proportional odds, \code{po}.
Default \code{aft}.
\item \code{overwrite} :: \code{logical(1)} \cr
If \code{FALSE} (default) then if the "pred" input already has a \code{distr}, the compositor does nothing
and returns the given \link{PredictionSurv}. If \code{TRUE} then the \code{distr} is overwritten with the \code{distr}
composed from \code{lp}/\code{crank} - this is useful for changing the prediction \code{distr} from one model
form to another.
}
}

\section{Internals}{

The respective \code{form}s above have respective survival distributions:
\deqn{aft: S(t) = S_0(\frac{t}{exp(lp)})}{aft: S(t) = S0(t/exp(lp))}
\deqn{ph: S(t) = S_0(t)^{exp(lp)}}{ph: S(t) = S0(t)^exp(lp)}
\deqn{po: S(t) = \frac{S_0(t)}{exp(-lp) + (1-exp(-lp)) S_0(t)}}{po: S(t) = S0(t) / [exp(-lp) + S0(t) (1-exp(-lp))]}
where \eqn{S_0}{S0} is the estimated baseline survival distribution, and \eqn{lp} is the predicted
linear predictor. If the input model does not predict a linear predictor then \code{crank} is
assumed to be the \code{lp} - \strong{this may be a strong and unreasonable assumption.}
}

\section{Fields}{

Only fields inherited from \link{PipeOp}.
}

\section{Methods}{

Only methods inherited from \link{PipeOp}.
}

\examples{
library(mlr3)
library(mlr3pipelines)
set.seed(42)

# Three methods to transform the cox ph predicted `distr` to an
#  accelerated failure time model
task = tgen("simsurv")$generate(30)

# Method 1 - Train and predict separately then compose
base = lrn("surv.kaplan")$train(task)$predict(task)
pred = lrn("surv.coxph")$train(task)$predict(task)
pod = po("distrcompose", param_vals = list(form = "aft", overwrite = TRUE))
pod$predict(list(base = base, pred = pred))

# Examples not run to save run-time.
\dontrun{
# Method 2 - Create a graph manually
gr = Graph$new()$
  add_pipeop(po("learner", lrn("surv.kaplan")))$
  add_pipeop(po("learner", lrn("surv.glmnet")))$
  add_pipeop(po("distrcompose"))$
  add_edge("surv.kaplan", "distrcompose", dst_channel = "base")$
  add_edge("surv.glmnet", "distrcompose", dst_channel = "pred")
gr$train(task)$gr$predict(task)

# Method 3 - Syntactic sugar: Wrap the learner in a graph.
cvglm.distr = distrcompositor(learner = lrn("surv.cvglmnet"),
                            estimator = "kaplan",
                            form = "aft")
cvglm.distr$fit(task)$predict(task)
}
}
\seealso{
\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp} and \link{distrcompositor}

Other survival compositors: 
\code{\link{PipeOpCrankCompositor}}
}
\concept{survival compositors}
