% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\docType{data}
\name{measures}
\alias{measures}
\alias{featperc}
\alias{timetrain}
\alias{timepredict}
\alias{timeboth}
\alias{sse}
\alias{measureSSE}
\alias{mse}
\alias{measureMSE}
\alias{rmse}
\alias{measureRMSE}
\alias{medse}
\alias{measureMEDSE}
\alias{sae}
\alias{measureSAE}
\alias{mae}
\alias{measureMAE}
\alias{medae}
\alias{measureMEDAE}
\alias{rsq}
\alias{measureRSQ}
\alias{expvar}
\alias{measureEXPVAR}
\alias{rrse}
\alias{measureRRSE}
\alias{rae}
\alias{measureRAE}
\alias{mape}
\alias{measureMAPE}
\alias{msle}
\alias{measureMSLE}
\alias{rmsle}
\alias{measureRMSLE}
\alias{kendalltau}
\alias{measureKendallTau}
\alias{spearmanrho}
\alias{measureSpearmanRho}
\alias{mmce}
\alias{measureMMCE}
\alias{acc}
\alias{measureACC}
\alias{ber}
\alias{measureBER}
\alias{multiclass.aunu}
\alias{measureAUNU}
\alias{multiclass.aunp}
\alias{measureAUNP}
\alias{multiclass.au1u}
\alias{measureAU1U}
\alias{multiclass.au1p}
\alias{measureAU1P}
\alias{multiclass.brier}
\alias{measureMulticlassBrier}
\alias{logloss}
\alias{measureLogloss}
\alias{ssr}
\alias{measureSSR}
\alias{qsr}
\alias{measureQSR}
\alias{lsr}
\alias{measureLSR}
\alias{kappa}
\alias{measureKAPPA}
\alias{wkappa}
\alias{measureWKAPPA}
\alias{auc}
\alias{measureAUC}
\alias{brier}
\alias{measureBrier}
\alias{brier.scaled}
\alias{measureBrierScaled}
\alias{bac}
\alias{measureBAC}
\alias{tp}
\alias{measureTP}
\alias{tn}
\alias{measureTN}
\alias{fp}
\alias{measureFP}
\alias{fn}
\alias{measureFN}
\alias{tpr}
\alias{measureTPR}
\alias{tnr}
\alias{measureTNR}
\alias{fpr}
\alias{measureFPR}
\alias{fnr}
\alias{measureFNR}
\alias{ppv}
\alias{measurePPV}
\alias{npv}
\alias{measureNPV}
\alias{fdr}
\alias{measureFDR}
\alias{mcc}
\alias{measureMCC}
\alias{f1}
\alias{measureF1}
\alias{gmean}
\alias{measureGMEAN}
\alias{gpr}
\alias{measureGPR}
\alias{multilabel.hamloss}
\alias{measureMultilabelHamloss}
\alias{multilabel.subset01}
\alias{measureMultilabelSubset01}
\alias{multilabel.f1}
\alias{measureMultilabelF1}
\alias{multilabel.acc}
\alias{measureMultilabelACC}
\alias{multilabel.ppv}
\alias{measureMultilabelPPV}
\alias{multilabel.tpr}
\alias{measureMultilabelTPR}
\alias{cindex}
\alias{cindex.uno}
\alias{iauc.uno}
\alias{ibrier}
\alias{meancosts}
\alias{mcp}
\alias{db}
\alias{G1}
\alias{G2}
\alias{silhouette}
\title{Performance measures.}
\usage{
measureSSE(truth, response)

measureMSE(truth, response)

measureRMSE(truth, response)

measureMEDSE(truth, response)

measureSAE(truth, response)

measureMAE(truth, response)

measureMEDAE(truth, response)

measureRSQ(truth, response)

measureEXPVAR(truth, response)

measureRRSE(truth, response)

measureRAE(truth, response)

measureMAPE(truth, response)

measureMSLE(truth, response)

measureRMSLE(truth, response)

measureKendallTau(truth, response)

measureSpearmanRho(truth, response)

measureMMCE(truth, response)

measureACC(truth, response)

measureBER(truth, response)

measureAUNU(probabilities, truth)

measureAUNP(probabilities, truth)

measureAU1U(probabilities, truth)

measureAU1P(probabilities, truth)

measureMulticlassBrier(probabilities, truth)

measureLogloss(probabilities, truth)

measureSSR(probabilities, truth)

measureQSR(probabilities, truth)

measureLSR(probabilities, truth)

measureKAPPA(truth, response)

measureWKAPPA(truth, response)

measureAUC(probabilities, truth, negative, positive)

measureBrier(probabilities, truth, negative, positive)

measureBrierScaled(probabilities, truth, negative, positive)

measureBAC(truth, response)

measureTP(truth, response, positive)

measureTN(truth, response, negative)

measureFP(truth, response, positive)

measureFN(truth, response, negative)

measureTPR(truth, response, positive)

measureTNR(truth, response, negative)

measureFPR(truth, response, negative, positive)

measureFNR(truth, response, negative, positive)

measurePPV(truth, response, positive, probabilities = NULL)

measureNPV(truth, response, negative)

measureFDR(truth, response, positive)

measureMCC(truth, response, negative, positive)

measureF1(truth, response, positive)

measureGMEAN(truth, response, negative, positive)

measureGPR(truth, response, positive)

measureMultilabelHamloss(truth, response)

measureMultilabelSubset01(truth, response)

measureMultilabelF1(truth, response)

measureMultilabelACC(truth, response)

measureMultilabelPPV(truth, response)

measureMultilabelTPR(truth, response)
}
\arguments{
\item{truth}{(\link{factor})\cr
Vector of the true class.}

\item{response}{(\link{factor})\cr
Vector of the predicted class.}

\item{probabilities}{(\link{numeric} | \link{matrix})\cr
a) For purely binary classification measures: The predicted probabilities for the positive class as a numeric vector.
b) For multiclass classification measures: The predicted probabilities for all classes, always as a numeric matrix, where
columns are named with class labels.}

\item{negative}{(\code{character(1)})\cr
The name of the negative class.}

\item{positive}{(\code{character(1)})\cr
The name of the positive class.}
}
\description{
A performance measure is evaluated after a single train/predict step and
returns a single number to assess the quality of the prediction (or maybe
only the model, think AIC). The measure itself knows whether it wants to be
minimized or maximized and for what tasks it is applicable.

All supported measures can be found by \link{listMeasures} or as a table in the
tutorial appendix: \url{https://mlr.mlr-org.com/articles/tutorial/measures.html}.

If you want a measure for a misclassification cost matrix, look at
\link{makeCostMeasure}. If you want to implement your own measure, look at
\link{makeMeasure}.

Most measures can directly be accessed via the function named after the
scheme measureX (e.g. measureSSE).

For clustering measures, we compact the predicted cluster IDs such that they
form a continuous series starting with 1. If this is not the case, some of
the measures will generate warnings.

Some measure have parameters. Their defaults are set in the constructor
\link{makeMeasure} and can be overwritten using \link{setMeasurePars}.
}
\references{
He, H. & Garcia, E. A. (2009)
\emph{Learning from Imbalanced Data.}
IEEE Transactions on Knowledge and Data Engineering, vol. 21, no. 9. pp. 1263-1284.

H. Uno et al.
\emph{On the C-statistics for Evaluating Overall Adequacy of Risk Prediction Procedures with Censored Survival Data}
Statistics in medicine. 2011;30(10):1105-1117. \url{https://doi.org/10.1002/sim.4154}.

H. Uno et al.
\emph{Evaluating Prediction Rules for T-Year Survivors with Censored Regression Models}
Journal of the American Statistical Association 102, no. 478 (2007): 527-37.
}
\seealso{
Other performance: 
\code{\link{ConfusionMatrix}},
\code{\link{calculateConfusionMatrix}()},
\code{\link{calculateROCMeasures}()},
\code{\link{estimateRelativeOverfitting}()},
\code{\link{makeCostMeasure}()},
\code{\link{makeCustomResampledMeasure}()},
\code{\link{makeMeasure}()},
\code{\link{performance}()},
\code{\link{setAggregation}()},
\code{\link{setMeasurePars}()}
}
\concept{performance}
\keyword{datasets}
