% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.mlogit}
\alias{vcov.mlogit}
\alias{print.vcov.mlogit}
\alias{summary.vcov.mlogit}
\alias{print.summary.vcov.mlogit}
\title{vcov method for mlogit objects}
\usage{
\method{vcov}{mlogit}(object, what = c("coefficient", "errors", "rpar"),
  subset = c("all", "iv", "sig", "sd", "sp", "chol"), type = c("cov",
  "cor", "sd"), reflevel = NULL, ...)

\method{print}{vcov.mlogit}(x, ...)

\method{summary}{vcov.mlogit}(object, ...)

\method{print}{summary.vcov.mlogit}(x, digits = max(3,
  getOption("digits") - 2), width = getOption("width"), ...)
}
\arguments{
\item{object}{a \code{mlogit} object (and a \code{vcov.mlogit} for the
summary method),}

\item{what}{indicates which covariance matrix has to be extracted : the
default value is \code{coefficients}, in this case, \code{vcov} behaves as
usual. If \code{what} equals \code{errors} the covariance matrix of the
errors of the model is returned. Finally, if \code{what} equals \code{rpar},
the covariance matrix of the random parameters are extracted,}

\item{subset}{the subset of the coefficients that have to be extracted (only
relevant if \code{what} \code{ = "coefficients"}),}

\item{type}{with this argument, the covariance matrix may be returned (the
default) ; the correlation matrix with the standard deviation on the
diagonal may also be extracted,}

\item{reflevel}{relevent for the extraction of the errors of a multinomial
probit model ; in this case the covariance matrix is of error differences is
returned and, with this argument, the alternative used for differentiation
is indicated,}

\item{...}{further arguments.}

\item{x}{a \code{vcov.mlogit} or a \code{summary.vcov.mlogit} object,}

\item{digits}{the number of digits,}

\item{width}{the width of the printing,}
}
\description{
The \code{vcov} method for \code{mlogit} objects extract the covariance
matrix of the coefficients, the errors or the random parameters.
}
\details{
This new interface replaces the \code{cor.mlogit} and \code{cov.mlogit}
functions which are deprecated.
}
\seealso{
\code{\link[=mlogit]{mlogit()}} for the estimation of multinomial logit
models.
}
\author{
Yves Croissant
}
\keyword{regression}
