% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/transforms.R
\name{mldr_transform}
\alias{mldr_transform}
\title{Transformns an MLDR into binary or multiclass datasets}
\usage{
mldr_transform(mldr, type = "BR", labels)
}
\arguments{
\item{mldr}{The mldr object to transform}

\item{type}{Indicates the type of transformation to apply. Possible types are:\itemize{
\item \code{"BR"} Produces one or more binary datasets, each one with one label
\item \code{"LP"} Produces a multiclass dataset using each labelset as class label
}}

\item{labels}{Vector with the label indexes to include in the transformation. All labels will be used if not specified}
}
\value{
A list of data.frames containing the resulting datasets (for BR) or a data.frame with the dataset (for LP).
The result is no longer an \code{mldr} object, but a plain \code{data.frame}
}
\description{
Transforms an \code{mldr} object into one or serveral binary or multiclass datasets, returning them as \code{data.frame} objects
}
\examples{
library(mldr)
emotionsbr <- mldr_transform(emotions, type = "BR")
emotionslp <- mldr_transform(emotions, type = "LP")
}

