% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist-pois.R
\name{Mixture Link Poisson Distribution}
\alias{Mixture Link Poisson Distribution}
\alias{d.mixlink.pois}
\alias{p.mixlink.pois}
\alias{r.mixlink.pois}
\title{Distribution functions}
\usage{
r.mixlink.pois(n, mean, Pi, kappa, save.latent = FALSE)

d.mixlink.pois(y, mean, Pi, kappa, log = FALSE)

p.mixlink.pois(y, mean, Pi, kappa)
}
\arguments{
\item{n}{Number of observations to draw}

\item{mean}{Parameter \eqn{\vartheta} of distribution}

\item{Pi}{Parameter \eqn{\bm{\pi}} of distribution}

\item{kappa}{Parameter \eqn{\kappa} of distribution}

\item{save.latent}{Save intermediate latent variables used during draw.}

\item{y}{Argument of pdf or cdf}

\item{log}{Return log of the result (TRUE or FALSE)}
}
\value{
\code{d.mixlink.pois} gives the density,
        \code{p.mixlink.pois} gives the distribution function, and
        \code{r.mixlink.pois} generates random deviates.
}
\description{
Functions for Mixture Link Poisson distribution
}
\examples{
  mean.true <- 20
  Pi.true <- c(1/4, 3/4)
  kappa.true <- 0.5
  r.mixlink.pois(n = 30, mean.true, Pi.true, kappa.true)
  d.mixlink.pois(y = 21, mean.true, Pi.true, kappa.true)
  d.mixlink.pois(y = 21, mean.true, Pi.true, kappa.true, log = TRUE)
  p.mixlink.pois(y = 21, mean.true, Pi.true, kappa.true)

}
\references{
Andrew M. Raim, Nagaraj K. Neerchal, and Jorge G. Morel.
            An Extension of Generalized Linear Models to Finite
            Mixture Outcomes. arXiv preprint: 1612.03302
}

