% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multilevel.icc.R
\name{multilevel.icc}
\alias{multilevel.icc}
\title{Intraclass Correlation Coefficient, ICC(1) and ICC(2)}
\usage{
multilevel.icc(x, group, type = 1, method = c("aov", "lme4", "nlme"),
               REML = TRUE, as.na = NULL, check = TRUE)
}
\arguments{
\item{x}{a vector, matrix or data frame.}

\item{group}{a vector representing the grouping structure (i.e., group variable).}

\item{type}{numeric value indicating the type of intraclass correlation coefficient, i.e.,
\code{type = 1} for ICC(1) and \code{type = 2} for ICC(2).}

\item{method}{a character string indicating the method used to estimate intraclass correlation coefficients, i.e.,
\code{method = "aov"} (default) ICC estimated using the \code{aov} function,
\code{method = "lme4"} ICC estimated using the \code{lmer} function in the \pkg{lme4} package,
\code{method = "nlme"} ICC estimated using the \code{lme} function in the \pkg{nlme} package.}

\item{REML}{logical: if \code{TRUE}, restricted maximum likelihood is used to estimate the null model when
using the \code{lmer} function in the \pkg{lme4} package or the \code{lme} function in the \pkg{nlme} package.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}
}
\value{
Returns a numeric vector with intraclass correlation coefficient(s).
}
\description{
This function computes the intraclass correlation coefficient ICC(1), i.e., proportion of the total variance explained
by the grouping structure, and ICC(2), i.e., reliability of aggregated variables.
}
\details{
Note that this function is restricted to two-level models.
}
\examples{
dat <- data.frame(id = c(1, 2, 3, 4, 5, 6, 7, 8, 9),
                  group = c(1, 1, 1, 1, 2, 2, 3, 3, 3),
                  x1 = c(2, 3, 2, 2, 1, 2, 3, 4, 2),
                  x2 = c(3, 2, 2, 1, 2, 1, 3, 2, 5),
                  x3 = c(2, 1, 2, 2, 3, 3, 5, 2, 4))

# ICC(1) for x
multilevel.icc(dat$x1, group = dat$group)

# ICC(1) for x, convert value 1 to NA
multilevel.icc(dat$x1, group = dat$group, as.na = 1)

# ICC(2) for x
multilevel.icc(dat$x1, group = dat$group, type = 2)

# ICC(1) for x,
# use lmer() function in the lme4 package to estimate ICC
multilevel.icc(dat$x1, group = dat$group, method = "lme4")

# ICC(1) for x1, x2, and x3
multilevel.icc(dat[, c("x1", "x2", "x3")], group = dat$group)
}
\references{
Hox, J., Moerbeek, M., & van de Schoot, R. (2018). \emph{Multilevel analysis: Techniques and applications} (3rd. ed.).
Routledge.

Snijders, T. A. B., & Bosker, R. J. (2012). \emph{Multilevel analysis: An introduction to basic and advanced multilevel
modeling} (2nd ed.). Sage Publishers.
}
\seealso{
\code{\link{multilevel.descript}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
