% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mipred.cv.R
\name{mipred.cv}
\alias{mipred.cv}
\title{Cross-validation prediction using multiple imputation}
\usage{
mipred.cv(formula, family, data, nimp, folds = NULL,
  method = "averaging", mice.options = NULL)
}
\arguments{
\item{formula}{A formula object providing a symbolic description of the
prediction model to be fitted.}

\item{family}{Specification of an appropriate error distribution and link
function.}

\item{data}{A data.frame containing calibration data on \code{n} samples.
Variables declared in \code{formula} must be found in \code{data}.}

\item{nimp}{Number of imputations used in the prediction of each observation.}

\item{folds}{Number of fold-partitions defined within \code{data} used in cross-validation.
An integer from 2 to \code{n}. Defaults to NULL which internally
sets \code{folds=n}, which puts each observation in \code{data}
into its own singleton fold for leave-one-out cross-validation.}

\item{method}{Imputation combination method. This defaults to
\code{"averaging"} for the prediction-averaging approach. The alternative
\code{"rubin"} applies the Rubin's rules pooled model.}

\item{mice.options}{Optional list containing arguments to be supplied to \code{mice}. Refer to the \code{mice} documentation for details.
The following options may be specified: \code{method}, \code{predictorMatrix}, \code{blocks},
\code{visitSequence}, \code{formulas}, \code{blots}, \code{post}, \code{defaultMethod},
\code{maxit}, \code{printFlag}, \code{seed}, \code{data.init}. Please refer to the
\code{mice} documentation for the description of these options. To set the number
of imputations \code{nimp} should be used. \code{seed} may be specified as a numeric vector
of length \code{nimp*folds} when \code{method} is set to \code{averaging} and of length \code{folds}
when \code{method} is set to \code{rubin}. Setting \code{seed} to a vector will cause each next
call to \code{mice} to use the next seed value in the vector. Setting the seed to a single
numeric value will cause all instances of
mice to use that same seed value. If you specify a seed vector of insufficient length
then the values will be recycled. The required length is \code{folds*nimp} for the averaging
approach and length \code{folds} for the rubin approach. The \code{defaultMethod} is set to
\code{c("pmm", "logreg", "polyreg", "polr")} by default. The default setting for
\code{printFlag} is FALSE. The default for \code{maxit} is 50. All other options are set
to \code{NULL} by default.}
}
\value{
A list consisting of 3 components,  of which the first is the Call and the last two are
matrices of predictions as follows.
\describe{\item{\code{pred}}{Matrix of predictions on the scale of the response
variable of dimension \code{n} by \code{nimp}.}
\item{\code{linpred}}{Matrix of predictions on the scale
  of the linear predictor of dimension \code{n} by \code{nimp}.}}
}
\description{
Calculates cross-validated predictions based on within-sample assessment and calibration using
generalized linear models with multiple imputations to account for missing values
in predictor data.
}
\examples{
\donttest{
# Generate a copy of the cll data and construct binary outcome from survival information
cll_bin<-cll
cll_bin$srv5y_s[cll_bin$srv5y>12] <- 0  # Apply administrative censorship at t=12 months
cll_bin$srv5y[cll_bin$srv5y>12]  <- 12
cll_bin$Status[cll_bin$srv5y_s==1]<- 1  # Define the new binary "Status" outcome variable
cll_bin$Status[cll_bin$srv5y_s==0] <- 0  # As numeric -> 1:Dead, 0:Alive
cll_bin$Censor <- NULL # Remove survival outcomes
cll_bin$srv5y <- NULL
cll_bin$srv5y_s <- NULL

# Cross-validate prediction using logistic regression in the first 100 samples
# Apply prediction-averaging using 5 imputations, 5 folds and maxit=5.
# Note these settings are only for illustration and should be set to higher values for
# practical use, particularly for nimp.
output<-mipred.cv(Status ~ age10+cyto, family=binomial, data=cll_bin[1:100,-1],
nimp=5, folds=5, mice.options=list(maxit=5))
}

}
\references{
\url{https://arxiv.org/abs/1810.05099}
}
\seealso{
\code{\link{mice}}
}
\author{
Bart J A Mertens, \email{b.mertens@lumc.nl}
}
