% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miic.plot.R
\name{miic.plot}
\alias{miic.plot}
\title{Igraph plotting function for miic}
\usage{
miic.plot(g, method = "log_confidence", igraphLayout = NULL,
  userLayout = NULL, verbose = F)
}
\arguments{
\item{g}{[a miic graph object]
The graph object returned by the miic execution.}

\item{method}{[a string; \emph{c("pcor", "log_confidence")}]
The column used to plot the strength of the edges. Default: pcor.}

\item{igraphLayout}{[an igraph layout object]
When set it is used to plot the network. See the igraph manual for more information.
 Default: \emph{layout_with_kk} or \emph{layout.circle} if the network has more than 40 nodes.}

\item{userLayout}{[a data frame]
An optional data frame reporting the position of nodes. Each line corresponds to the \emph{(x,y)}
coordinates of each vertex. This data frame must have three columns, the first containing the
name of the vertex as indicated in the colnames of the input data frame, the two others reporting the x and y positions.}

\item{verbose}{[a boolean value] If TRUE, debugging output is printed.}
}
\description{
This functions plots the network with the given layout (if specified) using the igraph package.
}
\details{
The plot reports the partial correlation or the log_confidence as strength of the edges.
}
