% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cm_net.R
\name{cm_net}
\alias{cm_net}
\title{Conditional maximization routine for the indirect estimation of origin-destination-type migration flow tables with known net migration totals.}
\usage{
cm_net(
  net_tot = NULL,
  m = NULL,
  tol = 1e-06,
  maxit = 500,
  verbose = TRUE,
  alpha0 = rep(1, length(net_tot))
)
}
\arguments{
\item{net_tot}{Vector of net migration totals to constrain the sum of the imputed cell row and columns. Elements must sum to zero.}

\item{m}{Array of auxiliary data. By default, set to 1 for all origin-destination-migrant typologies combinations.}

\item{tol}{Numeric value for the tolerance level used in the parameter estimation.}

\item{maxit}{Numeric value for the maximum number of iterations used in the parameter estimation.}

\item{verbose}{Logical value to indicate the print the parameter estimates at each iteration. By default \code{FALSE}.}

\item{alpha0}{Vector of initial estimates for alpha}
}
\value{
Conditional maximisation routine set up using the partial likelihood derivatives. The argument \code{net_tot} takes the known net migration totals.
The user must ensure that the net migration totals sum globally to zero.

Returns a \code{list} object with
\item{mu }{Array of indirect estimates of origin-destination matrices by migrant characteristic}
\item{it }{Iteration count}
\item{tol }{Tolerance level at final iteration}
}
\description{
The \code{cm_net} function finds the maximum likelihood estimates for fitted values in the log-linear model:
\deqn{\log y_{ij} = \log \alpha_{i} + \log \alpha_{i}^{-1} + \log m_{ij} }
}
\examples{
m <- matrix(data = 1:16, nrow = 4)
# m[lower.tri(m)] <- t(m)[lower.tri(m)]
addmargins(m)
sum_net(m)

y <- cm_net(net_tot = c(30, 40, -15, -55), m = m)
addmargins(y$n)
sum_net(y$n)

m <- matrix(data = c(0, 100, 30, 70, 50, 0, 45, 5, 60, 35, 0, 40, 20, 25, 20, 0),
            nrow = 4, ncol = 4, byrow = TRUE,
            dimnames = list(orig = LETTERS[1:4], dest = LETTERS[1:4]))
addmargins(m)
sum_net(m)

y <- cm_net(net_tot = c(-100, 125, -75, 50), m = m)
addmargins(y$n)
sum_net(y$n)
}
\author{
Guy J. Abel, Peter W. F. Smith
}
