% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpoutputs.R
\name{print.grpoutputs}
\alias{print.grpoutputs}
\title{Print information about grouped outputs}
\usage{
\method{print}{grpoutputs}(x, ...)
}
\arguments{
\item{x}{Object of class \code{grpoutputs}.}

\item{...}{Currently ignored.}
}
\value{
The argument \code{x}, invisibly, as for all \code{\link{print}}
methods.
}
\description{
Print information about objects of class \code{grpoutputs}.
}
\examples{
# Determine paths for data folders, each containing outputs for 10 runs of
# the PPHPC model
dir_nl_ok <- system.file("extdata", "nl_ok", package = "micompr")
dir_jex_diff <- system.file("extdata", "j_ex_diff", package = "micompr")
files <- glob2rx("stats400v1*.tsv")

# Create a grpoutputs object
go <- grpoutputs(6, c(dir_nl_ok, dir_jex_diff), c(files, files))

# Print information about object (could just type "go" instead)
print(go)

}
