% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_wqs_helper.R
\name{coef.wqs}
\alias{coef.wqs}
\title{Finding WQS Coefficients}
\usage{
\method{coef}{wqs}(object, ...)
}
\arguments{
\item{object}{An object of class "wqs", usually as a result of \code{\link{estimate.wqs}}.}

\item{...}{other arguments.}
}
\description{
An accessor function that returns the coefficients from the validation WQS model,
a \strong{wqs} object.
}
\details{
In a \strong{wqs} object, the \emph{fit} element, a \pkg{glm2} object, is extracted. See \code{\link{glm2}{glm2}}.
}
\examples{
# Use simulated dataset and set seed for reproducibility.
data(simdata87)
set.seed(23456)
Wa <- estimate.wqs(
  y = simdata87$y.scenario, X = simdata87$X.true[ , 1:3],
  B = 10, family = "binomial"
)
coef(Wa)
}
\seealso{
\code{\link[stats]{coef}}

Other wqs: \code{\link{analyze.individually}},
  \code{\link{do.many.wqs}}, \code{\link{estimate.wqs}},
  \code{\link{make.quantile.matrix}},
  \code{\link{plot.wqs}}, \code{\link{print.wqs}}
}
\concept{wqs}
\keyword{wqs}
