% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kldiv.R
\name{kldiv}
\alias{kldiv}
\title{Kullback-Leibler Divergence between Centered Multivariate generalized Gaussian Distributions}
\usage{
kldiv(sigma1, beta1, sigma2, beta2, eps = 1e-06)
}
\arguments{
\item{sigma1}{symmetric, positive-definite matrix. The dispersion matrix of the first distribution.}

\item{beta1}{positive real number. The shape parameter of the first distribution.}

\item{sigma2}{symmetric, positive-definite matrix. The dispersion matrix of the second distribution.}

\item{beta2}{positive real number. The shape parameter of the second distribution.}

\item{eps}{numeric. Precision for the computation of the Lauricella function
(see \code{\link{lauricella}}). Default: 1e-06.}
}
\value{
A  numeric value: the Kullback-Leibler divergence between the two distributions,
with two attributes \code{attr(, "epsilon")} (precision of the result of the Lauricella function)
and \code{attr(, "k")} (number of iterations).
}
\description{
Computes the Kullback- Leibler divergence between two random variables distributed
according to multivariate generalized Gaussian distributions (MGGD) with zero means.
}
\details{
Given \eqn{X_1}, a random vector of \eqn{R^p} distributed according to the MGGD
with parameters \eqn{(0, \Sigma_1, \beta_1)}
and \eqn{X_2}, a random vector of \eqn{R^p} distributed according to the MGGD
with parameters \eqn{(0, \Sigma_2, \beta_2)}.

The Kullback-Leibler divergence between \eqn{X_1} and \eqn{X_2} is given by:

\eqn{ KL(X_1||X_2) = ln{\left(\frac{\beta_1 |\Sigma_1|^{-1/2} \Gamma\left(\frac{p}{2\beta_2}\right)}{\beta_2 |\Sigma_2|^{-1/2} \Gamma\left(\frac{p}{2\beta_1}\right)}\right)} + \frac{p}{2} \left(\frac{1}{\beta_2} - \frac{1}{\beta_1}\right) ln{2} - \frac{p}{2\beta_2} + 2^{\frac{\beta_2}{\beta_1}-1} \frac{\Gamma{\left(\frac{\beta_2}{\beta_1} + \frac{p}{\beta_1}\right)}}{\Gamma{\left(\frac{p}{2 \beta_1}\right)}} \lambda_p^{\beta_2} }

\eqn{\times F_D^{(p-1)}\left(-\beta_1; \frac{1}{2},\dots,\frac{1}{2}; \frac{p}{2}; 1-\frac{\lambda_{p-1}}{\lambda_p},\dots,1-\frac{\lambda_{1}}{\lambda_p}\right) }

where \eqn{\lambda_1 < ... < \lambda_{p-1} < \lambda_p} are the eigenvalues
of the matrix \eqn{\Sigma_1 \Sigma_2^{-1}}.

This computation uses the \code{\link{lauricella}} function.
}
\examples{
beta1 <- 0.74
beta2 <- 0.55
Sigma1 <- matrix(c(0.8, 0.3, 0.2, 0.3, 0.2, 0.1, 0.2, 0.1, 0.2), nrow = 3)
Sigma2 <- matrix(c(1, 0.3, 0.2, 0.3, 0.5, 0.1, 0.2, 0.1, 0.7), nrow = 3)

# Kullback-Leibler divergence
kl12 <- kldiv(Sigma1, beta1, Sigma2, beta2)
kl21 <- kldiv(Sigma2, beta2, Sigma1, beta1)
print(kl12)
print(kl21)

# Distance (symmetrized Kullback-Leibler divergence)
kldist <- as.numeric(kl12) + as.numeric(kl21)
print(kldist)

}
\references{
N. Bouhlel, A. Dziri, Kullback-Leibler Divergence Between Multivariate Generalized Gaussian Distributions.
IEEE Signal Processing Letters, vol. 26 no. 7, July 2019.
\doi{10.1109/LSP.2019.2915000}
}
\author{
Nizar Bouhlel, Pierre Santagostini
}
