% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_ind.R
\name{pred_ind}
\alias{pred_ind}
\title{Trophic measures}
\usage{
pred_ind(dataset, store = FALSE, dec_c = ".", verbose = FALSE)
}
\arguments{
\item{dataset}{A data.frame obtained from \code{read_data}.}

\item{store}{A logical value indicating if the user want to store the results in a file.}

\item{dec_c}{A character used for decimal separator on results file.}

\item{verbose}{A logical value indicating indicating if progress messages should be given.}
}
\value{
This function returns a data.frame with all the calculated trophic measures:
\item{per_pred}{\% Predator.}
\item{per_filt}{\% Filtering collector.}
\item{per_shred}{\% Shredders.}
\item{per_scrap}{\% Scrapers.}
\item{per_gath}{\% Gathering collector.}
\item{n_pred}{N° of Predator.}
\item{n_filt}{N° of Filtering collector.}
\item{n_shred}{N° of Shredders.}
\item{n_scrap}{N° of Scrapers.}
\item{n_gath}{N° of Gathering collector.}
}
\description{
Calculates trophic measures
}
\details{
Trophic metrics are surrogates of complex processes such as trophic interaction, production and food source availability. Specialized feeders, such as scrapers, piercers, and shredders, are the more sensitive, and are thought to be well represented in healthy streams. Generalists, such as collectors and filterers, have a broader range of acceptable food materials than specialists, and are thus more tolerant to pollution that might alter availability of certain food (Barbour et al., 1996).
}
\examples{

#Example data is a properly formatted table with richness measures of two sites
example_data

#Run pred_ind with that example_data
pred<-pred_ind(example_data)

#Check results
pred
}
\references{
\itemize{
\item{Barbour MT, Gerritsen J, Griffith GE, Frydenborg R, McCarron E, White JS & Bastian ML (1996) \doi{10.2307/1467948>}}
}
}
\seealso{
\link[metrix]{read_data}
}
\author{
Juan Manuel Cabrera and Julieta Capeleti.
}
