% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ebar.R
\name{ebar}
\alias{ebar}
\title{Relationship between mean metabolic rate (\eqn{\bar{\epsilon}}) and abundance}
\usage{
ebar(x)
}
\arguments{
\item{x}{an object of class meteESF.}
}
\value{
An object of class \code{meteRelaT}. The object contains a list with the following elements.
\describe{
  \item{\code{pred}}{predicted relationship}
  \item{\code{obs}}{observed relationship}
}
}
\description{
\code{ebar} calculates the relationship between average metabolic rate of a species and that species' abundance. Also known as the Damuth relationship
}
\details{
See examples.
}
\examples{
data(arth)
esf1 <- meteESF(spp=arth$spp,
               abund=arth$count,
               power=arth$mass^(.75),
               minE=min(arth$mass^(.75)))
damuth <- ebar(esf1)
}
\author{
Andy Rominger <ajrominger@gmail.com>, Cory Merow
}
\references{
Harte, J. 2011. Maximum entropy and ecology: a theory of abundance, distribution, and energetics. Oxford University Press.
}
\seealso{
meteDist, sad.meteESF, metePsi
}
\keyword{METE,}
\keyword{MaxEnt,}
\keyword{ecosystem}
\keyword{function}
\keyword{lagrange}
\keyword{multiplier,}
\keyword{structure}

