% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxmap--docs.R
\name{filter_obs}
\alias{filter_obs}
\title{Filter observations with a list of conditions}
\arguments{
\item{obj}{An object of type [taxmap()]}

\item{data}{Dataset names, indexes, or a logical vector that indicates which datasets in
`obj$data` to filter. If multiple datasets are filterd at once, then they must be the same
length.}

\item{...}{One or more filtering conditions. Any variable name that appears
in [all_names()] can be used as if it was a vector on its own. Each
filtering condition can be one of two things:
* `integer`: One or more dataset indexes.
* `logical`: A `TRUE`/`FALSE` vector of length equal to the number of
items in the dataset.}

\item{drop_taxa}{(`logical` of length 1) If `FALSE`, preserve taxa
even if all of their observations are filtered out. If `TRUE`, remove
taxa for which all observations were filtered out. Note that only taxa that
are unobserved due to this filtering will be removed; there might be other
taxa without observations to begin with that will not be removed.}

\item{drop_obs}{(`logical`) This only has an effect when `drop_taxa` is
`TRUE`. When `TRUE`, observations for other data sets (i.e. not `data`)
assigned to taxa that are removed when filtering `data` are also removed.
Otherwise, only data for taxa that are not present in all other data sets
will be removed. This option can be either simply `TRUE`/`FALSE`, meaning
that all data sets will be treated the same, or a logical vector can be
supplied with names corresponding one or more data sets in `obj$data`. For
example, `c(abundance = TRUE, stats = FALSE)` would remove observations in
`obj$data$abundance`, but not in `obj$data$stats`.}

\item{subtaxa}{(`logical` or `numeric` of length 1) This only has an effect
when `drop_taxa` is `TRUE`. If `TRUE`, include subtaxa of taxa passing the
filter. Positive numbers indicate the number of ranks below the target taxa
to return. `0` is equivalent to `FALSE`. Negative numbers are equivalent to
`TRUE`.}

\item{supertaxa}{(`logical`  or `numeric` of length 1) This only has an
effect when `drop_taxa` is `TRUE`. If `TRUE`, include supertaxa of taxa
passing the filter. Positive numbers indicate the number of ranks above the
target taxa to return. `0` is equivalent to `FALSE`. Negative numbers are
equivalent to `TRUE`.}

\item{reassign_obs}{(`logical`) This only has an effect when `drop_taxa` is
`TRUE`. If `TRUE`, observations assigned to removed taxa will be reassigned
to the closest supertaxon that passed the filter. If there are no supertaxa
of such an observation that passed the filter, they will be filtered out if
`drop_obs` is `TRUE`. This option can be either simply `TRUE`/`FALSE`,
meaning that all data sets will be treated the same, or a logical vector
can be supplied with names corresponding one or more data sets in
`obj$data`. For example, `c(abundance = TRUE, stats = FALSE)` would
reassign observations in `obj$data$abundance`, but not in `obj$data$stats`.}

\item{target}{DEPRECIATED. use "data" instead.}
}
\value{
An object of type [taxmap()]
}
\description{
Filter data in a [taxmap()] object (in `obj$data`) with a
set of conditions.  See
[dplyr::filter()] for the inspiration for this function and more
information. Calling the function using the `obj$filter_obs(...)` style
edits "obj" in place, unlike most R functions. However, calling the function
using the `filter_obs(obj, ...)` imitates R's traditional copy-on-modify
semantics, so "obj" would not be changed; instead a changed version would be
returned, like most R functions.
\preformatted{
obj$filter_obs(data, ..., drop_taxa = FALSE, drop_obs = TRUE,
               subtaxa = FALSE, supertaxa = TRUE, reassign_obs = FALSE)
filter_obs(obj, data, ..., drop_taxa = FALSE, drop_obs = TRUE,
           subtaxa = FALSE, supertaxa = TRUE, reassign_obs = FALSE)}
}
\examples{
# Filter by row index
filter_obs(ex_taxmap, "info", 1:2)

# Filter by TRUE/FALSE
filter_obs(ex_taxmap, "info", dangerous == FALSE)
filter_obs(ex_taxmap, "info", dangerous == FALSE, n_legs > 0)
filter_obs(ex_taxmap, "info", n_legs == 2)

# Remove taxa whose obserservations were filtered out
filter_obs(ex_taxmap, "info", n_legs == 2, drop_taxa = TRUE)

# Preserve other data sets while removing taxa
filter_obs(ex_taxmap, "info", n_legs == 2, drop_taxa = TRUE,
           drop_obs = c(abund = FALSE))

# When filtering taxa, do not return supertaxa of taxa that are preserved
filter_obs(ex_taxmap, "info", n_legs == 2, drop_taxa = TRUE,
           supertaxa = FALSE)

# Filter multiple datasets at once
filter_obs(ex_taxmap, c("info", "phylopic_ids", "foods"), n_legs == 2)

}
\seealso{
Other taxmap manipulation functions: 
\code{\link{arrange_obs}()},
\code{\link{arrange_taxa}()},
\code{\link{filter_taxa}()},
\code{\link{mutate_obs}()},
\code{\link{sample_frac_obs}()},
\code{\link{sample_frac_taxa}()},
\code{\link{sample_n_obs}()},
\code{\link{sample_n_taxa}()},
\code{\link{select_obs}()},
\code{\link{transmute_obs}()}
}
\concept{taxmap manipulation functions}
