% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memery.R
\name{memeApp}
\alias{memeApp}
\title{Run memery example app}
\usage{
memeApp()
}
\description{
Launch the memery example app in your browser.
}
\details{
This example app launches with animated gif support and relevant initial example gif if the magick package and ImageMagick software are installed on the user's system.
Otherwise, a simplified version of the app that does not provide gif support launches and starting images must be jpg or png.

Due to how \code{meme_gif} works, gifs will not display in a hosted app, i.e., on \code{shinyapps.io}.
Memes based on gifs with many frames also take longer to render. By default, the app is set to render any animated gif input into a static meme using only the first frame in the animated gif.
If it takes one second to render a single frame, expect it to take about 43 seconds to render the 43-frame example animated gif that comes preloaded in the app.
If the user wishes to wait, the input control menu for output frames can be switched from first frame to all frames.

While jpg and png memes will display in a hosted app like on \code{shinyapps.io}, the impact font will also not likely be available on a given server.
For all these reasons this packaged app is not hosted elsewhere. The best and intended experience is to use the app locally via the \code{memery} package.

All ggplot objects that exist in the global environment when the app is launched propagate a selection menu in app for use as inset plots to overlay meme image backgrounds.
If there are no ggplot objects in the global environment, one named \code{memery_testplot} will be created within the app environment and will appear in the selection menu instead.

A meme can be saved from an app by right-clicking on the image in your web browser and selecting the save option just like with any other web images.
}
\examples{
\dontrun{memeApp()}
}
