% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/elmt-methods.R
\name{elmt}
\alias{elmt}
\alias{elmt,EL-method}
\alias{elmt,QGLM-method}
\title{Empirical likelihood multiple tests}
\usage{
\S4method{elmt}{EL}(object, rhs = NULL, lhs = NULL, alpha = 0.05, control = el_control())

\S4method{elmt}{QGLM}(object, rhs = NULL, lhs = NULL, alpha = 0.05, control = el_control())
}
\arguments{
\item{object}{An object that inherit from \linkS4class{EL}, including
\linkS4class{CEL}, \linkS4class{LM}, and \linkS4class{GLM}.}

\item{rhs}{A numeric vector (column matrix) or a list of numeric vectors for
the right-hand sides of hypotheses. Defaults to \code{NULL}. See ‘Details’.}

\item{lhs}{A numeric matrix or a list of numeric matrices for the left-hand
sides of hypothesis. Each row of the matrices gives a linear combination of
the parameters in \code{object}. The number of columns should be equal to the
number of parameters. Defaults to \code{NULL}. See ‘Details’.}

\item{alpha}{A single numeric for the overall significance level. Defaults to
\code{0.05}.}

\item{control}{An object of class \linkS4class{ControlEL} constructed by
\code{\link[=el_control]{el_control()}}.}
}
\value{
An object of class of \linkS4class{ELMT}.
}
\description{
Tests multiple linear hypotheses simultaneously.
}
\details{
\code{\link[=elmt]{elmt()}} tests multiple hypotheses simultaneously. Each hypothesis
corresponds to the constrained empirical likelihood ratio described in
\linkS4class{CEL}. \code{rhs} and \code{lhs} cannot be both \code{NULL}. The right-hand
side and left-hand side of each hypothesis must be specified as described
in \code{\link[=elt]{elt()}}.

For specifying linear contrasts more conveniently, \code{rhs} and \code{lhs} also
take a numeric vector and a numeric matrix, respectively. Each element of
\code{rhs} and each row of \code{lhs} correspond to a contrast (hypothesis).

The vector of empirical likelihood ratio statistics asymptotically follows
a multivariate chi-square distribution under the complete null hypothesis.
The multiple testing procedure asymptotically controls the family-wise
error rate at the level \code{alpha}. Based on the distribution of the maximum
of the test statistics, the adjusted p-values are estimated by Monte Carlo
simulation.
}
\examples{
## Example 1: bivariate mean (list `rhs` & no `lhs`)
data("women")
fit <- el_mean(women, par = c(65, 135))
rhs <- list(c(64, 133), c(66, 140))
set.seed(143)
elmt(fit, rhs = rhs)

## Example 2: pairwise comparison (no `rhs` & matrix `lhs`)
data("clothianidin")
fit2 <- el_lm(clo ~ -1 + trt, clothianidin)
lhs <- matrix(c(
  1, -1, 0, 0,
  0, 1, -1, 0,
  0, 0, 1, -1
), byrow = TRUE, nrow = 3)
set.seed(629)
elmt(fit2, lhs = lhs)

## Example 3: arbitrary hypotheses (list `rhs` & list `lhs`)
data("mtcars")
fit <- el_lm(mpg ~ wt + qsec, data = mtcars)
lhs <- list(rbind(c(1, 4, 0)), rbind(c(0, 1, 0), c(0, 0, 1)))
rhs <- list(0, c(-6, 1))
elmt(fit, rhs = rhs, lhs = lhs)
}
\references{
Kim E, MacEachern S, Peruggia M (2021).
“Empirical Likelihood for the Analysis of Experimental Designs.”
arxiv:2112.09206. URL \url{https://arxiv.org/abs/2112.09206}.
}
\seealso{
\code{\link[=el_control]{el_control()}}, \code{\link[=elt]{elt()}}
}
