\name{summary.mediate.mer}
\alias{summary.mediate.mer}
\alias{print.summary.mediate.mer}
\alias{print.summary.mediate.mer.2}
\alias{print.summary.mediate.mer.3}

\title{Summarizing Output from Mediation Analysis of Multilevel Models}
\description{
Function to report results from mediation analysis of multilevel models. Reported categories are mediation effect, direct effect, total effect, and proportion of total effect mediated. All quantities reported with confidence intervals. Group-specific effects and confidence intervals reported based on the mediator or the outcome group. Group-average quantities reported as default. 
}
\usage{

  \method{summary}{mediate.mer}(object, output = c("default","byeffect","bygroup"), ...)

  \method{print}{summary.mediate.mer}(x, ...)

  \method{print}{summary.mediate.mer.2}(x, ...)

  \method{print}{summary.mediate.mer.3}(x, ...)
}

\arguments{
\item{object}{ output from mediate function.}
\item{output}{ group-specific effects organized by effect if output = "byeffect"; group-specific effects organized by group if output = "bygroup"; group-average effects reported as default.}
\item{x}{ output from summary.mediate.mer function.}
\item{...}{ additional arguments affecting the summary produced.}
}

\references{
Tingley, D., Yamamoto, T., Hirose, K., Imai, K. and Keele, L. (2014). "mediation: R package for Causal Mediation Analysis", Journal of Statistical Software, Vol. 59, No. 5, pp. 1-38. 

Imai, K., Keele, L., Tingley, D. and Yamamoto, T. (2011). Unpacking the Black Box of Causality: Learning about Causal Mechanisms from Experimental and Observational Studies, American Political Science Review, Vol. 105, No. 4 (November), pp. 765-789.

Imai, K., Keele, L. and Tingley, D. (2010) A General Approach to Causal Mediation Analysis, Psychological Methods, Vol. 15, No. 4 (December), pp. 309-334.

Imai, K., Keele, L. and Yamamoto, T. (2010) Identification, Inference, and Sensitivity Analysis for Causal Mediation Effects, Statistical Science, Vol. 25, No. 1 (February), pp. 51-71.

Imai, K., Keele, L., Tingley, D. and Yamamoto, T. (2009) "Causal Mediation Analysis Using R" in Advances in Social Science Research Using R, ed. H. D. Vinod New York: Springer.}

\author{Kentaro Hirose, Princeton University, \email{hirose@princeton.edu}.}

\seealso{\code{\link{mediate}}, \code{\link{plot.mediate.mer}}.}

\examples{ 
# Examples with JOBS II Field Experiment

# **For illustration purposes a small number of simulations are used**
\dontrun{
data(jobs)
require(lme4)

# educ: mediator group
# occp: outcome group

# Varying intercept for mediator 
model.m <- glmer(job_dich ~ treat + econ_hard + (1 | educ), 
             		     family = binomial(link = "probit"), data = jobs)

# Varying intercept and slope for outcome
model.y <- glmer(work1 ~ treat + job_dich + econ_hard + (1 + treat | occp), 
                family = binomial(link = "probit"), data = jobs)

# Output based on mediator group
multilevel <- mediate(model.m, model.y, treat = "treat", 
                      mediator = "job_dich", sims=50, group.out="educ")

# Group-average effects  
summary(multilevel)

# Group-specific effects organized by effect
summary(multilevel, output="byeffect")

# Group-specific effects organized by group
summary(multilevel, output="bygroup")
}
}
