% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcreplicate.R
\name{mc_replicate}
\alias{mc_replicate}
\title{Multi-core replicate.}
\source{
Modified from: Richard McElreath (2020). rethinking: Statistical
Rethinking book package. R package version 2.13.
\url{https://github.com/rmcelreath/rethinking}
}
\usage{
mc_replicate(n, expr, refresh = 0.1, mc.cores = 2)
}
\arguments{
\item{n}{integer: the number of replications.}

\item{expr}{the expression (a language object, usually a call) to evaluate repeatedly.}

\item{refresh}{status update refresh interval}

\item{mc.cores}{number of cores to use}
}
\value{
A vector, matrix, or list of length \code{n}.
}
\description{
Multi-core replicate.
}
\examples{
one_sim <- function(n, control_prob, rel_effect) {
  treat_prob <- control_prob + (control_prob * rel_effect)
  cy <- rbinom(n = n, size = 1, prob = control_prob)
  ty <- rbinom(n = n, size = 1, prob = treat_prob)
  mean(ty) - mean(cy)
  }

  mc_replicate(10, one_sim(n = 100, control_prob = 0.1, rel_effect = 0.01))

}
