% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcpfit_methods.R
\encoding{UTF-8}
\name{summary.mcpfit}
\alias{summary.mcpfit}
\alias{summary}
\alias{fixef}
\alias{fixef.mcpfit}
\alias{fixed.effects}
\alias{ranef}
\alias{ranef.mcpfit}
\alias{random.effects}
\alias{print.mcpfit}
\alias{print}
\title{Summarise mcpfit objects}
\usage{
\method{summary}{mcpfit}(object, width = 0.95, digits = 2, prior = FALSE, ...)

fixef(object, width = 0.95, prior = FALSE, ...)

ranef(object, width = 0.95, prior = FALSE, ...)

\method{print}{mcpfit}(x, ...)
}
\arguments{
\item{object}{An \code{\link{mcpfit}} object.}

\item{width}{Float. The width of the highest posterior density interval
(between 0 and 1).}

\item{digits}{a non-null value for digits specifies the minimum number of
significant digits to be printed in values. The default, NULL, uses
getOption("digits"). (For the interpretation for complex numbers see signif.)
Non-integer values will be rounded down, and only values greater than or
equal to 1 and no greater than 22 are accepted.}

\item{prior}{TRUE/FALSE. Summarise prior instead of posterior?}

\item{...}{Currently ignored}

\item{x}{An \code{\link{mcpfit}} object.}
}
\value{
A data frame with parameter estimates and MCMC diagnostics.
OBS: The change point distributions are often not unimodal and symmetric so
the intervals can be deceiving Plot them using \code{plot_pars(fit)}.
\itemize{
\item \code{mean} is the posterior mean
\item \code{lower} is the lower quantile of the highest-density interval (HDI) given in \code{width}.
\item \code{upper} is the upper quantile.
\item \code{Rhat} is the Gelman-Rubin convergence diagnostic which is often taken to
be acceptable if < 1.1. It is computed using \code{\link[coda]{gelman.diag}}.
\item \code{n.eff} is the effective sample size computed using \code{\link[coda]{effectiveSize}}.
Low effective sample sizes are also obvious as poor mixing in trace plots
(see \code{plot_pars(fit)}). Read how to deal with such problems \href{https://lindeloev.github.io/mcp/articles/tips.html}{here}
\item \code{ts_err} is the time-series error, taking autoregressive correlation
into account. It is computed using \code{\link[coda]{spectrum0.ar}}.
}

For simulated data, the summary contains two additional columns so that it
is easy to inspect whether the model can recover the parameters. Run
simulation and summary multiple times to get a sense of the robustness.
\itemize{
\item \code{sim} is the value used to generate the data.
\item \code{match} is \code{"OK"} if \code{sim} is contained in the HDI interval (\code{lower} to
\code{upper}).
}
}
\description{
Summarise parameter estimates and model diagnostics.
}
\section{Functions}{
\itemize{
\item \code{fixef}: Get population-level ("fixed") effects of an \code{\link{mcpfit}} object.

\item \code{ranef}: Get varying ("random") effects of an \code{\link{mcpfit}} object.

\item \code{print.mcpfit}: Print the posterior summary of an \code{\link{mcpfit}} object.
}}

\examples{
# Typical usage
summary(demo_fit)
summary(demo_fit, width = 0.8, digits = 4)  # Set HDI width

# Get the results as a data frame
results = summary(demo_fit)

# Varying (random) effects
# ranef(my_fit)

# Summarise prior
summary(demo_fit, prior = TRUE)

}
\author{
Jonas Kristoffer Lindeløv \email{jonas@lindeloev.dk}
}
