% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_jags_model.R
\name{run_jags_model}
\alias{run_jags_model}
\title{Wrapper function to run the jags model for estimating the proportion of modern contraceptive methods supplied by the public & private Sectors using a Bayesian hierarchical penalized spline model for the national and subnational administration levels}
\usage{
run_jags_model(
  jagsdata,
  jagsparams = NULL,
  n_iter = 80000,
  n_burnin = 10000,
  n_thin = 35,
  n_chain = 2,
  n_cores = NULL,
  ...
)
}
\arguments{
\item{jagsdata}{The object from the mcmsupply::get_modelinputs() function.}

\item{jagsparams}{The parameters of the JAGS model you wish to review}

\item{n_iter}{Default is 80000. Number of itterations to do in JAGS model.}

\item{n_burnin}{Default is 10000. Number of samples to burn-in in JAGS model.}

\item{n_thin}{Default is 35. Number of samples to thin by in JAGS model.}

\item{n_chain}{Default is 2. Number of chains to run in your MCMC sample.}

\item{n_cores}{The number of cores to use for parallel execution in subnational estimation. If not specified, the number of cores is set to the value of options("cores"), if specified, or to approximately half the number of cores detected by the parallel package.}

\item{...}{Arguments from the mcmsupply::get_modelinputs() function.}
}
\value{
returns the jags model object
}
\description{
Wrapper function to run the jags model for estimating the proportion of modern contraceptive methods supplied by the public & private Sectors using a Bayesian hierarchical penalized spline model for the national and subnational administration levels
}
\examples{
\donttest{
raw_data <- get_data(national=TRUE, local=TRUE, mycountry="Nepal")
jagsdata <- get_modelinputs(startyear=1990, endyear=2025.5, nsegments=12, raw_data)
run_jags_model(jagsdata, n_iter=5, n_burnin=1, n_thin=1)
}
}
