% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcglm.R
\docType{data}
\name{soya}
\alias{soya}
\title{Soybeans}
\format{a \code{data.frame} with 75 records and 7 variables.}
\source{
Bonat, W. H. (2016). Multiple Response Variables Regression
Models in R: The mcglm Package. Journal of Statistical Software, submitted.
}
\usage{
data(soya)
}
\description{
Experiment carried out in a vegetation house with
soybeans. The experiment has two plants by plot with three levels of
the factor amount of water in the soil (\code{water})
and five levels of potassium fertilization (\code{pot}).
The plots were arranged in five blocks (\code{block}).
Three response variables are of the interest, namely, grain yield,
number of seeds and number of viable peas per plant.
The data set has 75 observations of 7 variables.

\itemize{

\item \code{pot} - Factor five levels of potassium fertilization.

\item \code{water} - Factor three levels of amount of water in the soil.

\item \code{block} - Factor five levels.

\item \code{grain} - Continuous - Grain yield per plant.

\item \code{seeds} - Count - Number of seeds per plant.

\item \code{viablepeas} - Binomial - Number of viable peas per plant.

\item \code{totalpeas} - Binomial - Total number of peas per plant.
}
}
\examples{
library(mcglm)
library(Matrix)
data(soya, package="mcglm")
formu <- grain ~ block + factor(water) * factor(pot)
Z0 <- mc_id(soya)
fit <- mcglm(linear_pred = c(formu), matrix_pred = list(Z0),
          data = soya)
          anova(fit)
}
\keyword{datasets}

