% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_cauchy.R
\name{.cor_cauchy}
\alias{.cor_cauchy}
\title{Calculate Cauchy correlation}
\usage{
.cor_cauchy(x, a, alpha, nu = 1, nugget = 0)
}
\arguments{
\item{x}{A numeric vector, matrix, or array.}

\item{a}{Smooth parameter, \eqn{a>0}.}

\item{alpha}{Scale parameter, \eqn{\alpha\in(0, 1]}.}

\item{nu}{Power parameter, \eqn{\nu>0}. Default is 1.}

\item{nugget}{The nugget effect \eqn{\in[0, 1]}.}
}
\value{
Correlations of the same dimension as \code{x}.
}
\description{
Calculate Cauchy correlation
}
\details{
The Cauchy correlation function with scale parameter \eqn{a} and
smooth parameter \eqn{\alpha} has the form
\deqn{C(x)=(1-\text{nugget})(a|x|^{2\alpha} + 1)^{-\nu}+\text{nugget}\cdot
\delta_{x=0},} where \eqn{\delta_{x=0}} is 1 when \eqn{x=0} and 0 otherwise.
}
\references{
Gneiting, T., and Schlather, M. (2004). Stochastic Models That Separate
Fractal Dimension and the Hurst Effect. SIAM Review, 46(2), 269–282.
}
\keyword{internal}
