% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognorm_rp.R
\name{lognorm_rp}
\alias{lognorm_rp}
\title{A function to fit Log-Normal renewal model}
\usage{
lognorm_rp(data, t, y)
}
\arguments{
\item{data}{as input inter-event times}

\item{t}{as user-specified time intervals (used to compute hazard rate)}

\item{y}{as user-specified time point (used to compute time-to-event probability)}
}
\value{
returns list of estimates after fitting Log-Normal renewal model
\describe{
\item{par1}{Estimated mean (on the log scale) of the Log-Normal model}
\item{par2}{Estimated standard deviation (on the log scale)of the Log-Normal model}
\item{logL}{Negative log-likelihood}
\item{AIC}{Akaike information criterion (AIC)}
\item{BIC}{Bayesian information criterion (BIC)}
\item{mu_hat}{Estimated mean}
\item{pr_hat}{Estimated (logit) probabilities}
\item{haz_hat}{Estimated (log) hazard rates}
}
}
\description{
A function to fit Log-Normal renewal model
}
\examples{
set.seed(42)
data <-  rgamma(100,3,0.01)

# set some parameters
t = seq(100, 200, by=10)  # time intervals
y = 304  # cut-off year for estimating probablity

# fit Log-Normal renewal model
result <- marp::lognorm_rp(data, t, y)

# print result
cat("par1 = ", result$par1, "\n")
cat("par2 = ", result$par2, "\n")
cat("logL = ", result$logL, "\n")
cat("AIC = ", result$AIC, "\n")
cat("BIC = ", result$BIC, "\n")
cat("mu_hat = ", result$mu_hat, "\n")
cat("pr_hat = ", result$pr_hat, "\n")

}
