% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ipbes_biomes.R
\name{ipbes_biomes}
\alias{ipbes_biomes}
\alias{get_ipbes_biomes}
\title{Terrestrial and Aquatic Biomes}
\source{
\url{https://zenodo.org/records/3975694}
}
\usage{
get_ipbes_biomes()
}
\value{
A function that returns an \code{sf} footprint object.
}
\description{
This resource is part of the Global Assessment Report on Biodiversity and
Ecosystem Services and represents a division of the Earth's surface
into several subcategories. The classification differentiates between
biomes and anthromes. Biomes are differentiated between terrestrial and aquatic
biomes.
}
\details{
Terrestrial biomes include:
\itemize{
\item Tropical and subtropical dry and humid forests
\item Temperate and boreal forests and woodlands
\item Mediterranean forests, woodlands and scrub
\item Tundra and High Mountain habitats
\item Tropical and subtropical savannas and grasslands
\item Temperate Grasslands
\item Deserts and xeric shrublands
\item Wetlands – peatlands, mires, bogs
}

Aquatic biomes include:
\itemize{
\item Cryosphere
\item Aquaculture areas
\item Inland surface waters and water bodies/freshwater
\item Shelf ecosystems (neritic and intertidal/littoral zone)
\item Open ocean pelagic systems (euphotic zone)
}
}
\references{
IPBES (2019): Summary for policymakers of the global assessment
report on biodiversity and ecosystem services of the Intergovernmental
Science-Policy Platform on Biodiversity and Ecosystem Services. S. Díaz, J.
Settele, E. S. Brondízio, H. T. Ngo, M. Guèze, J. Agard, A. Arneth, P.
Balvanera, K. A. Brauman, S. H. M. Butchart, K. M. A. Chan, L. A. Garibaldi,
K. Ichii, J. Liu, S. M. Subramanian, G. F. Midgley, P. Miloslavich, Z.
Molnár, D. Obura, A. Pfaff, S. Polasky, A. Purvis, J. Razzaque, B. Reyers, R.
Roy Chowdhury, Y. J. Shin, I. J. Visseren-Hamakers, K. J. Willis, and C. N.
Zayas (eds.). IPBES secretariat, Bonn, Germany. 56 pages.
https://doi.org/10.5281/zenodo.3553579
}
\keyword{resource}
