% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gsw_time_series.R
\name{gsw_time_series_indicator}
\alias{gsw_time_series_indicator}
\alias{calc_gsw_time_series}
\title{Calculate Global Surface Water Time Series}
\format{
A function returning a tibble with time series of global surface
water data classes.
}
\usage{
calc_gsw_time_series()
}
\description{
This function calculates the total area of the global surface water time
series data, separated by the following classes:
}
\details{
\itemize{
\item No Observation: It was not possible to determine whether a pixel was water
(this may be the case for frozen areas or during the polar night in extreme
latitudes).
\item Permanent Water: Water was detected in twelve months per year or in a
combination of permanent and no observation.
\item Seasonal Water: Water and no water was detected.
\item No Water: No Water was detected.
}

The required resources for this indicator are:
\itemize{
\item \link{gsw_time_series_resource}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
outdir <- file.path(tempdir(), "mapme-data")
path_gsw_ts <- file.path(outdir, "gsw_time_series")
gsw_fnames_short <- dir(path_gsw_ts, pattern = ".tif$")
gsw_fnames_long <- sub("v5_", "VER5-0_yearlyClassification", gsw_fnames_short)

invisible(file.copy(
   file.path(path_gsw_ts, gsw_fnames_short),
   file.path(path_gsw_ts, gsw_fnames_long)
))
}
\dontrun{
library(mapme.biodiversity)
library(sf)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- read_sf(
  system.file("extdata", "shell_beach_protected_area_41057_B.gpkg",
              package = "mapme.biodiversity"
))
aoi <- get_resources(aoi, get_gsw_time_series (years = 2000:2001))
aoi <- calc_indicators(aoi, calc_gsw_time_series())
aoi <- portfolio_long(aoi)

aoi
}
}
\keyword{indicator}
