% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_deforestation_drivers.R
\name{deforestation_drivers}
\alias{deforestation_drivers}
\alias{calc_deforestation_drivers}
\title{Calculate deforestation drivers}
\usage{
calc_deforestation_drivers()
}
\value{
A function that returns a tibble with 3 columns indicating the
class of a deforestation driver, the absolute area in ha, and the
percentage in relation to the total area of forest loss as indicated by
the Fritz et al. (2022) resource.
}
\description{
This function extracts areal statistics for the drivers of deforestation
based on the data source produced by Fritz et al (2022).
}
\details{
The required resource for this indicator is:
\itemize{
\item \link{fritz_et_al}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(get_fritz_et_al(resolution = 100)) \%>\%
  calc_indicators(calc_deforestation_drivers()) \%>\%
  tidyr::unnest(deforestation_drivers)

aoi
}
}
\keyword{indicator}
