% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portfolio.R
\name{init_portfolio}
\alias{init_portfolio}
\title{Initialization of a biodiversity portfolio object}
\usage{
init_portfolio(
  x,
  years,
  outdir = getwd(),
  tmpdir = tempdir(),
  cores = NULL,
  aria_bin = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{The sf object to be transformed to a portfolio}

\item{years}{Numeric vector for time frame of the analysis handed over as a
vector of consecutive years}

\item{outdir}{Character indicating the directory where resources will be
written to. If the directory does not exist, we will attempt to create it.
The output director cannot be equal to the temporary directory. Defaults
to the current working directory.}

\item{tmpdir}{Character vector to a directory used for intermediate files.
Defaults to the output of \code{tempdir()}, e.g. the current R session's
temporal directory. If a custom file path does not exist, we will attempt
to create it. Cannot be equal to the output directory. Note, that for
raster calculations we will set the temporal directory for the \code{terra}
package here. Please make sure that enough disk space is available because
some intermediate calculations can become quite large.}

\item{cores}{Deprecated. Use future-style parallelzation instead.}

\item{aria_bin}{A character vector to an aria2c executable for parallel
downloads}

\item{verbose}{Logical, defaults to TRUE, indicating if progress information
is printed.}
}
\value{
The sf portfolio object \code{x} with amended attributes controlling the
processing behaviour further down the processing chain.
}
\description{
This function expects an \code{sf} object as its first argument that contains
only geometry of type \code{POLYGON} or \code{MULTIPOLYGON}. Each row of the
object is considered a single asset in the portfolio for which biodiversity
indicators will be calculated further down the processing chain. Some
preliminary checks are conducted, e.g. that the CRS of the object is
EPSG:4326 otherwise it will be transformed. Some portfolio wide parameters
such as the output directory for downloaded data sets, a temporal directory
for intermediate calculations can be set by the user to have more fine-control
of the workflow. However, these parameters are also set to sensible defaults
and thus can be omitted during portfolio initialization.
}
\keyword{function}
