% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_treeloss.R
\docType{data}
\name{treeloss}
\alias{treeloss}
\title{Calculate treeloss statistics}
\format{
A tibble with a column for years, treecover (in ha), and emissions (in Mg CO2)
}
\description{
This functions allows to efficiently calculate the treecover and emissions
indicators in a single function call together. Since most of the pre-processing
operations for treecover and emissions are the same, it is more efficient
to calculate them in one run if users are actually interested in both statistics.
Otherwise users are advised to use the respective single indicator functions.
The required resources for this indicator are:
\itemize{
\item \link{treecover2000}
\item \link{lossyear}
\item \link{greenhouse}.
}
}
\details{
The following arguments can be set:
\describe{
\item{min_size}{The minum size of a forest patch to be considered as forest in ha.}
\item{min_cover}{The minimum cover percentage per pixel to be considered as forest.}
}
}
\examples{
library(sf)
library(mapme.biodiversity)

temp_loc <- file.path(tempdir(), "mapme.biodiversity")
if(!file.exists(temp_loc)){
dir.create(temp_loc)
resource_dir <- system.file("res", package = "mapme.biodiversity")
file.copy(resource_dir, temp_loc, recursive = TRUE)
}

(aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg", package = "mapme.biodiversity") \%>\%
  read_sf() \%>\%
  init_portfolio(
    years = 2016:2017,
    outdir = file.path(temp_loc, "res"),
    tmpdir = tempdir(),
    add_resources = FALSE,
    cores = 1,
    verbose = FALSE
  ) \%>\%
  get_resources(
    resources = c("treecover2000", "lossyear", "greenhouse"),
    vers_treecover = "GFC-2020-v1.8", vers_lossyear = "GFC-2020-v1.8"
  ) \%>\%
  calc_indicators("treeloss", min_size = 1, min_cover = 30) \%>\%
  tidyr::unnest(treeloss))
}
\keyword{indicator}
