% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{adm_rows}
\alias{adm_rows}
\alias{adm_rows.data.frame}
\alias{adm_rows.missing}
\alias{adm_rows.mrgmod}
\title{Add administration lines to a dataset}
\usage{
adm_rows(x, ...)

\method{adm_rows}{data.frame}(
  x,
  ID = NULL,
  time = NULL,
  evid = 1L,
  cmt,
  amt,
  mdv = 1L,
  addl = NULL,
  ss = NULL,
  ii = NULL,
  rate = NULL,
  .datehour = NULL,
  ...
)

\method{adm_rows}{missing}(...)

\method{adm_rows}{mrgmod}(x, cmt = adm_cmt(x), rate = NULL, ...)
}
\arguments{
\item{x}{either a data.frame or a 'mrgsolve' model object}

\item{...}{additional columns or arguments for \code{\link[mrgsolve:ev]{mrgsolve::ev()}}}

\item{ID}{subject ID (default is 1)}

\item{time}{event time. Default is 0 if no previous events. Mind consistency with \code{.datehour}.}

\item{evid}{event identification (default is 1 for administration, 0 for observation)}

\item{cmt}{compartment (no default, except if \verb{[ADM]} was tagged in the \verb{$CMT} block in model code. See \code{examples}.)}

\item{amt}{dose amount (for administration records only)}

\item{mdv}{missing dependent value (default is 1 for administration records)}

\item{addl}{additional dose (optional)}

\item{ss}{steady-state (optional, is this dose the last of an infinity of administration? Yes, 1, or no, 0)}

\item{ii}{inter-dose interval (optional, use it with \code{ss} and \code{addl})}

\item{rate}{rate of administration (optional, set to -2 if you model zero-order infusion. See \code{examples}.)}

\item{.datehour}{a object of class POSIXct, a number or a character vector that can be passed to \code{\link[=parse_datehour]{parse_datehour()}}. Using \code{.datehour} will update the value of \code{time} in the dataset, with units in hours. Mind consistency with the \code{time} argument.}
}
\value{
a data.frame, or a 'mrgsolve' model with a dataset in the \verb{@args$data} slot (accessible with \code{\link[=get_data]{get_data()}}).
}
\description{
The \code{adm_rows()} function adds an one or several administration lines to a dataset provided as a proper data.frame or within a 'mrgsolve' model. Used in combination with \code{\link[=obs_rows]{obs_rows()}} and \code{\link[=add_covariates]{add_covariates()}}, it helps the creation of datasets in the proper format for simulations with 'mrgsolve' or parameter estimation with 'mapbayr', as explained in \link{data_helpers}.
}
\examples{
# Create a dataset from scratch
adm_rows(amt = 100, cmt = 1)

# Pipe-friendly addition of administration record to a pre-existing dataset
library(magrittr)
adm_rows(amt = 100, cmt = 1) \%>\%
  adm_rows(time = 3, amt = 200, cmt = 1, addl = 3, ii = 1)

# Inform times using the `.datehour` argument:
adm_rows(.datehour = "2020-01-01 11:11", amt = 100, cmt = 1) \%>\%
  adm_rows(.datehour = "2020-01-02 22:22", amt = 200, cmt = 1) \%>\%
  adm_rows(time = 48, amt = 300, cmt = 1)

# Start from a 'mrgsolve' model
library(mrgsolve)
house() \%>\%
  adm_rows(amt = 100, cmt = 1) \%>\%
  adm_rows(time = 3, amt = 200, cmt = 1, addl = 3, ii = 1) \%>\%
  mrgsim(delta = 1)

# Default administration compartments
# Set default administration compartments in the code with `[ADM]`
model <- mcode("model", "
$CMT @annotated
DEPOT : Depot [ADM]
CENTR : Central
", compile = FALSE)
adm_cmt(model)

# Thus, no need to manually specify `cmt = 1` anymore.
model \%>\%
  adm_rows(amt = 100) \%>\%
  adm_rows(time = 3, amt = 200, addl = 3, ii = 1) \%>\%
  get_data()

# Automatic lines duplication if multiple depot compartments
# Automatic `rate = -2` increment if model with 0-order absorption
model <- mcode("model", "
$PARAM DUR = 1.0
$CMT @annotated
DEPOT : Depot [ADM]
CENTR : Central [ADM]
$MAIN
D_CENTR = DUR ;
", compile = FALSE)
adm_cmt(model)

model \%>\%
  adm_rows(amt = 100) \%>\%
  adm_rows(time = 3, amt = 200, addl = 3, ii = 1) \%>\%
  get_data()
}
\seealso{
\link{data_helpers}
}
