% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_med_mod_serial_parallel}
\alias{data_med_mod_serial_parallel}
\title{Sample Dataset:
Serial-Parallel Mediation with Two
Moderators}
\format{
A data frame with 100 rows
and 9 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w1}{Moderator 1. Numeric.}
\item{w2}{Moderator 2. Numeric.}
\item{m11}{Mediator 1 in Path 1. Numeric.}
\item{m12}{Mediator 2 in Path 2. Numeric.}
\item{m2}{Mediator 2. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med_mod_serial_parallel
}
\description{
A serial-parallel
mediation model with some paths
moderated.
}
\examples{
library(lavaan)
data(data_med_mod_serial_parallel)
data_med_mod_serial_parallel$xw1 <-
 data_med_mod_serial_parallel$x *
 data_med_mod_serial_parallel$w1
data_med_mod_serial_parallel$m2w2 <-
 data_med_mod_serial_parallel$m2 *
 data_med_mod_serial_parallel$w2
mod <-
"
m11 ~ a1 * x + w1 + da11 * xw1 + c1 + c2
m12 ~ b11 * m11 + x + w1 + c1 + c2
m2 ~ a2 * x + c1 + c2
y ~ b12 * m12 + b2 * m2 + m11 + x + w1 + w2 + db2 * m2w2 + c1 + c2
w1 ~~ v_w1 * w1
w1 ~ m_w1 * 1
w2 ~~ v_w2 * w2
w2 ~ m_w2 * 1
a1b11b22 := a1 * b11 * b12
a2b2 := a2 * b2
ab := a1b11b22 + a2b2
a1b11b12_w1lo := (a1 + da11 * (m_w1 - sqrt(v_w1))) * b11 * b12
a1b11b12_w1hi := (a1 + da11 * (m_w1 + sqrt(v_w1))) * b11 * b12
a2b2_w2lo := a2 * (b2 + db2 * (m_w2 - sqrt(v_w2)))
a2b2_w2hi := a2 * (b2 + db2 * (m_w2 + sqrt(v_w2)))
"
fit <- sem(mod, data_med_mod_serial_parallel,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[parameterEstimates(fit)$label != "", ]
}
\keyword{datasets}
