% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqr.R
\name{qqr}
\alias{qqr}
\title{Creates a qq object}
\source{
The calculation of the expected p-value is taken from the
  \code{\link[qqman]{qq}} function from the
  \href{https://github.com/stephenturner/qqman}{\code{qqman}} package by
  \href{http://www.gettinggeneticsdone.com/}{Stephen Turner}
}
\usage{
qqr(x, p = "P", snp, gene, annotation1, annotation2, ...)
}
\arguments{
\item{x}{A \code{data.frame} which must contain at least the following
column: \itemize{ \item{a p-value, must be numeric} }}

\item{p}{A string denoting the column name for the p-values. Default is
\code{p = "P"}. This column must be \code{numeric} or \code{integer}.
Should not have missing, NA, NaN, or NULL values and should be between 0
and 1.}

\item{snp}{A string denoting the column name for the SNP names (e.g. rs
number). More generally, this column could be anything that identifies each
point being plotted. For example, in an Epigenomewide association study
(EWAS) this could be the probe name or cg number. This column should be a
\code{character}. This argument is optional, however it is necessary to
specify if you want to highlight points on the plot using the
\code{highlight} argument in the \code{\link{qqly}} function}

\item{gene}{A string denoting the column name for the GENE names. This column
could be a \code{character} or \code{numeric}. More generally this could be
any annotation information that you want to include in the plot. This
argument is optional.}

\item{annotation1}{A string denoting the column name for an annotation. This
column could be a \code{character} or \code{numeric}. This could be any
annotation information that you want to include in the plot (e.g. zscore,
effect size, minor allele frequency). This argument is optional.}

\item{annotation2}{A string denoting the column name for an annotation. This
column could be a \code{character} or \code{numeric}. This could be any
annotation information that you want to include in the plot (e.g. zscore,
effect size, minor allele frequency). This argument is optional.}

\item{...}{currently ignored}
}
\value{
An list object of class \code{qqr} with the following elements
  \describe{  \item{data}{processed data to be used for plotting the Q-Q plot
  including the observed and expected p-values on the -log10 scale}
  \item{pName, snpName, geneName, annotation1Name, annotation2Name}{The names
  of the columns corresponding to the data provided. This information is used
  for annotating the plot in the \code{\link{qqly}} function } }
}
\description{
An object of class qq includes all the needed information for producing a
quantile-quantile plot of p-values. The goal is to seperate the
pre-processing of the quantile-quantile plot elements from the graphical
rendaring of the object, which could be done using any graphical device
including \code{\link[plotly]{plot_ly}} and \code{\link[graphics]{plot}} in
base \code{R}.
}
\note{
This function will return an error if any of the p-values are NA, less
  than 0 or greater than 1
}
\examples{
library(manhattanly)
qqrObj <- qqr(HapMap, snp = "SNP", highlight = significantSNP)
class(qqrObj)
head(qqrObj[["data"]])

}
\seealso{
\code{\link{qqly}}
}

