% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-msg-header.R
\name{fetch_msg_header}
\alias{fetch_msg_header}
\title{Fetch Message Headers}
\usage{
fetch_msg_header(imapconf, msg_id, by = "MSN", fields = NULL,
  negate_fields = FALSE, peek = TRUE, partial = NULL,
  write_to_disk = FALSE, keep_in_mem = TRUE, retries = 2)
}
\arguments{
\item{imapconf}{An object of class \code{imapconf} generated with
\link{configure_imap} and with a \code{mbox} item added after a
mailbox selection with \link{select_mailbox}.}

\item{msg_id}{A numeric vetor containing one or more messages ids.}

\item{by}{Which id (\code{MSN} or \code{UID}) to use when searching for
messages. \code{"MSN"} or message squence number is a message's relative
position to the older message in the mailbox. It may change after deleting
or moving messages. For instance, if a message is deleted, message sequence
numbers are reordered to fill the gap. \code{"UID"} or unique identifier
is always the same during the life cycle of a message. Default is
\code{"MSN"}.}

\item{fields}{A character vector specifying which field(s) to fetch from
messages. See \link{section_or_field_options}}

\item{negate_fields}{If \code{TRUE}, negates the search and seeks for
"NOT in the field". Default is \code{FALSE}.}

\item{peek}{If \code{TRUE}, it does not mark messages as "read" after
fetching. Default is \code{TRUE}.}

\item{partial}{\code{NULL} or a character string with format
"startchar.endchar" indicating the size (in characters) of a message slice
to fetch. Default is \code{NULL}, which fetchs the full specified content.}

\item{write_to_disk}{If \code{TRUE} writes fetch content of each message
to the disk as a text file in the working directory. Default is \code{FALSE}.}

\item{keep_in_mem}{If \code{TRUE} keeps a copy of fetch results as an
list in the R session when \code{write_to_disk = TRUE}. Default is
\code{FALSE}. It can only be set \code{TRUE} when
\code{write_to_disk = TRUE}.}

\item{retries}{Number of attempts to connect and execute the command. Default
is \code{2}.}
}
\value{
A \code{list} or/and text files containing the fetch results.
}
\description{
Fetch header fields of one or more messages.
}
\examples{

\dontrun{

# configure IMAP
library(mRpostman)
imapconf <- configure_imap(url="imaps://your.imap.server.com",
                           username="your_username",
                           password=rstudioapi::askForPassword()
                          )
# fetching
results <- imapconf \%>\%
    select_mailbox(mbox = "TAM") \%>\%
    search_before(date_char = "10-may-2012", by = "UID") \%$\% #exposition pipe - two argg
    fetch_msg_header(imapconf = imapconf, msg_id = msg_id, fields = c("From", "To"))

}

}
\seealso{
Other fetch: \code{\link{fetch_full_msg}},
  \code{\link{fetch_msg_metadata}},
  \code{\link{fetch_msg_text}}
}
\concept{fetch}
