% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http.R
\name{lumenHTTP}
\alias{lumenHTTP}
\title{Lumen Database HTTP Requests}
\usage{
lumenHTTP(verb = "GET", path = "", query = list(), body = "",
  base = "https://lumendatabase.org", token = Sys.getenv("LUMEN_TOKEN"),
  ...)
}
\arguments{
\item{verb}{A character string containing an HTTP verb, defaulting to \dQuote{GET}.}

\item{path}{A character string with the API endpoint (should begin with a slash).}

\item{query}{A list specifying any query string arguments to pass to the API.}

\item{body}{A character string of request body data.}

\item{base}{A character string specifying the base URL for the API.}

\item{token}{A character string containing a Lumen Database API token. If missing, defaults to value stored in environment variable \env{LUMEN_TOKEN}.}

\item{...}{Additional arguments passed to an HTTP request function, such as \code{\link[httr]{GET}}.}
}
\value{
A list.
}
\description{
This is the workhorse function for executing API requests for the Lumen Database.
}
\details{
This is mostly an internal function for executing API requests. In almost all cases, users do not need to access this directly.
}

